/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.conditions;

import io.tarantool.driver.api.conditions.FieldIdentifier;
import io.tarantool.driver.exceptions.TarantoolIndexNotFoundException;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.utils.Assert;
import java.util.Optional;

public class NamedIndex
implements FieldIdentifier<TarantoolIndexMetadata, String> {
    private final String name;

    public NamedIndex(String name) {
        Assert.hasText(name, "Index name should not be empty");
        this.name = name;
    }

    @Override
    public TarantoolIndexMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolIndexMetadata> indexMetadata = metadataOperations.getIndexByName(spaceMetadata.getSpaceName(), this.name);
        if (!indexMetadata.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceMetadata.getSpaceName(), this.name);
        }
        return indexMetadata.get();
    }

    @Override
    public String toIdentifier() {
        return this.name;
    }
}

