/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.conditions;

import io.tarantool.driver.protocol.TarantoolIteratorType;

public enum Operator {
    EQ("="),
    LT("<"),
    LE("<="),
    GT(">"),
    GE(">=");

    private final String code;

    private Operator(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public TarantoolIteratorType toIteratorType() {
        switch (this) {
            case LT: {
                return TarantoolIteratorType.ITER_LT;
            }
            case LE: {
                return TarantoolIteratorType.ITER_LE;
            }
            case GT: {
                return TarantoolIteratorType.ITER_GT;
            }
            case GE: {
                return TarantoolIteratorType.ITER_GE;
            }
        }
        return TarantoolIteratorType.ITER_EQ;
    }

    public String toString() {
        return "Operator{opCode=" + this.code.toString() + '}';
    }
}

