/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.tuple.operations;

import io.tarantool.driver.api.tuple.TarantoolField;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.api.tuple.operations.TupleOperation;
import io.tarantool.driver.api.tuple.operations.TupleOperationAdd;
import io.tarantool.driver.api.tuple.operations.TupleOperationBitwiseAnd;
import io.tarantool.driver.api.tuple.operations.TupleOperationBitwiseOr;
import io.tarantool.driver.api.tuple.operations.TupleOperationBitwiseXor;
import io.tarantool.driver.api.tuple.operations.TupleOperationDelete;
import io.tarantool.driver.api.tuple.operations.TupleOperationInsert;
import io.tarantool.driver.api.tuple.operations.TupleOperationSet;
import io.tarantool.driver.api.tuple.operations.TupleOperationSubtract;
import io.tarantool.driver.api.tuple.operations.TupleSpliceOperation;
import io.tarantool.driver.exceptions.TarantoolSpaceOperationException;
import io.tarantool.driver.utils.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class TupleOperations {
    private final List<TupleOperation> operations = new ArrayList<TupleOperation>();
    private final List<TupleOperation> proxyOperations = new ArrayList<TupleOperation>();

    private TupleOperations(List<TupleOperation> operations) {
        this.operations.addAll(operations);
        this.proxyOperations.addAll(operations.stream().map(TupleOperation::toProxyTupleOperation).collect(Collectors.toList()));
    }

    private TupleOperations(TupleOperation operation) {
        this.addOperationToList(operation);
    }

    private void addOperationToList(TupleOperation operation) {
        this.operations.add(operation);
        this.proxyOperations.add(operation.toProxyTupleOperation());
    }

    public TupleOperations addOperation(TupleOperation operation) {
        Integer filedIndex = operation.getFieldIndex();
        String fieldName = operation.getFieldName();
        Optional<TupleOperation> existField = filedIndex != null ? this.operations.stream().filter(op -> filedIndex.equals(op.getFieldIndex())).findFirst() : this.operations.stream().filter(op -> fieldName.equals(op.getFieldName())).findFirst();
        if (existField.isPresent()) {
            throw new TarantoolSpaceOperationException("Double update of the same field (%s)", filedIndex != null ? filedIndex : fieldName);
        }
        this.addOperationToList(operation);
        return this;
    }

    public List<TupleOperation> asList() {
        return this.operations;
    }

    public List<TupleOperation> asProxyOperationList() {
        return this.proxyOperations;
    }

    public static TupleOperations fromTarantoolTuple(TarantoolTuple tuple) {
        Assert.notNull(tuple, "Tuple for update must not be null");
        List<TarantoolField> tupleFields = tuple.getFields();
        if (tupleFields.isEmpty()) {
            throw new TarantoolSpaceOperationException("Cannot perform update with an empty tuple");
        }
        ArrayList<TupleOperation> operations = new ArrayList<TupleOperation>(tupleFields.size());
        for (int i = 0; i < tupleFields.size(); ++i) {
            operations.add(new TupleOperationSet(i, (Object)tupleFields.get(i)));
        }
        return new TupleOperations(operations);
    }

    public static TupleOperations add(int fieldIndex, Number value) {
        return new TupleOperations(new TupleOperationAdd(fieldIndex, value));
    }

    public TupleOperations andAdd(int fieldIndex, Number value) {
        return this.addOperation(new TupleOperationAdd(fieldIndex, value));
    }

    public static TupleOperations add(String fieldName, Number value) {
        return new TupleOperations(new TupleOperationAdd(fieldName, value));
    }

    public TupleOperations andAdd(String fieldName, Number value) {
        return this.addOperation(new TupleOperationAdd(fieldName, value));
    }

    public static TupleOperations bitwiseAnd(int fieldIndex, long value) {
        return new TupleOperations(new TupleOperationBitwiseAnd(fieldIndex, value));
    }

    public TupleOperations andBitwiseAnd(int fieldIndex, long value) {
        return this.addOperation(new TupleOperationBitwiseAnd(fieldIndex, value));
    }

    public static TupleOperations bitwiseAnd(String fieldName, long value) {
        return new TupleOperations(new TupleOperationBitwiseAnd(fieldName, value));
    }

    public TupleOperations andBitwiseAnd(String fieldName, long value) {
        return this.addOperation(new TupleOperationBitwiseAnd(fieldName, value));
    }

    public static TupleOperations bitwiseOr(int fieldIndex, long value) {
        return new TupleOperations(new TupleOperationBitwiseOr(fieldIndex, value));
    }

    public TupleOperations andBitwiseOr(int fieldIndex, long value) {
        return this.addOperation(new TupleOperationBitwiseOr(fieldIndex, value));
    }

    public static TupleOperations bitwiseOr(String fieldName, long value) {
        return new TupleOperations(new TupleOperationBitwiseOr(fieldName, value));
    }

    public TupleOperations andBitwiseOr(String fieldName, long value) {
        return this.addOperation(new TupleOperationBitwiseOr(fieldName, value));
    }

    public static TupleOperations bitwiseXor(int fieldIndex, long value) {
        return new TupleOperations(new TupleOperationBitwiseXor(fieldIndex, value));
    }

    public TupleOperations andBitwiseXor(int fieldIndex, long value) {
        return this.addOperation(new TupleOperationBitwiseXor(fieldIndex, value));
    }

    public static TupleOperations bitwiseXor(String fieldName, long value) {
        return new TupleOperations(new TupleOperationBitwiseXor(fieldName, value));
    }

    public TupleOperations andBitwiseXor(String fieldName, long value) {
        return this.addOperation(new TupleOperationBitwiseXor(fieldName, value));
    }

    public static TupleOperations delete(int fieldIndex, int fieldsCount) {
        return new TupleOperations(new TupleOperationDelete(fieldIndex, fieldsCount));
    }

    public TupleOperations andDelete(int fieldIndex, int fieldsCount) {
        return this.addOperation(new TupleOperationDelete(fieldIndex, fieldsCount));
    }

    public static TupleOperations delete(String fieldName, int fieldsCount) {
        return new TupleOperations(new TupleOperationDelete(fieldName, fieldsCount));
    }

    public TupleOperations andDelete(String fieldName, int fieldsCount) {
        return this.addOperation(new TupleOperationDelete(fieldName, fieldsCount));
    }

    public static TupleOperations insert(int fieldIndex, Object value) {
        return new TupleOperations(new TupleOperationInsert(fieldIndex, value));
    }

    public TupleOperations andInsert(int fieldIndex, Object value) {
        return this.addOperation(new TupleOperationInsert(fieldIndex, value));
    }

    public static TupleOperations insert(String fieldName, Object value) {
        return new TupleOperations(new TupleOperationInsert(fieldName, value));
    }

    public TupleOperations andInsert(String fieldName, Object value) {
        return this.addOperation(new TupleOperationInsert(fieldName, value));
    }

    public static TupleOperations set(int fieldIndex, Object value) {
        return new TupleOperations(new TupleOperationSet(fieldIndex, value));
    }

    public TupleOperations andSet(int fieldIndex, Object value) {
        return this.addOperation(new TupleOperationSet(fieldIndex, value));
    }

    public static TupleOperations set(String fieldName, Object value) {
        return new TupleOperations(new TupleOperationSet(fieldName, value));
    }

    public TupleOperations andSet(String fieldName, Object value) {
        return this.addOperation(new TupleOperationSet(fieldName, value));
    }

    public static TupleOperations splice(int fieldIndex, int position, int offset, String replacement) {
        return new TupleOperations(new TupleSpliceOperation(fieldIndex, position, offset, replacement));
    }

    public TupleOperations andSplice(int fieldIndex, int position, int offset, String replacement) {
        return this.addOperation(new TupleSpliceOperation(fieldIndex, position, offset, replacement));
    }

    public static TupleOperations splice(String fieldName, int position, int offset, String replacement) {
        return new TupleOperations(new TupleSpliceOperation(fieldName, position, offset, replacement));
    }

    public TupleOperations andSplice(String fieldName, int position, int offset, String replacement) {
        return this.addOperation(new TupleSpliceOperation(fieldName, position, offset, replacement));
    }

    public static TupleOperations subtract(int fieldIndex, Number value) {
        return new TupleOperations(new TupleOperationSubtract(fieldIndex, value));
    }

    public TupleOperations andSubtract(int fieldIndex, Number value) {
        return this.addOperation(new TupleOperationSubtract(fieldIndex, value));
    }

    public static TupleOperations subtract(String fieldName, Number value) {
        return new TupleOperations(new TupleOperationSubtract(fieldName, value));
    }

    public TupleOperations andSubtract(String fieldName, Number value) {
        return this.addOperation(new TupleOperationSubtract(fieldName, value));
    }
}

