/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.auth;

import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.utils.Assert;

public class SimpleTarantoolCredentials
implements TarantoolCredentials {
    private static final String DEFAULT_USER = "guest";
    private static final String DEFAULT_PASSWORD = "";
    private final String user;
    private final String password;

    public SimpleTarantoolCredentials(String user, String password) {
        Assert.hasText(user, "User must not be empty");
        Assert.notNull(password, "Password must not be null");
        this.user = user;
        this.password = password;
    }

    public SimpleTarantoolCredentials() {
        this.user = DEFAULT_USER;
        this.password = DEFAULT_PASSWORD;
    }

    @Override
    public String getUsername() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEmpty() {
        return this.user.isEmpty() || this.password.isEmpty();
    }
}

