/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.core.TarantoolChannelInitializer;
import io.tarantool.driver.core.TarantoolConnection;
import io.tarantool.driver.core.TarantoolConnectionImpl;
import io.tarantool.driver.exceptions.TarantoolClientException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TarantoolConnectionFactory {
    private final TarantoolClientConfig config;
    private final Bootstrap bootstrap;

    public TarantoolConnectionFactory(TarantoolClientConfig config, Bootstrap bootstrap) {
        this.config = config;
        this.bootstrap = bootstrap;
    }

    public CompletableFuture<TarantoolConnection> singleConnection(InetSocketAddress serverAddress) {
        CompletableFuture<Channel> connectionFuture = new CompletableFuture<Channel>();
        RequestFutureManager requestManager = new RequestFutureManager(this.config);
        TarantoolVersionHolder versionHolder = new TarantoolVersionHolder();
        ChannelFuture future = ((Bootstrap)this.bootstrap.clone().handler((ChannelHandler)new TarantoolChannelInitializer(this.config, requestManager, versionHolder, connectionFuture))).remoteAddress((SocketAddress)serverAddress).connect();
        future.addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                connectionFuture.completeExceptionally(new TarantoolClientException("Failed to connect to the Tarantool server", f.cause()));
            }
        }));
        return connectionFuture.thenApply(ch -> new TarantoolConnectionImpl(requestManager, versionHolder, (Channel)ch));
    }

    public Collection<CompletableFuture<TarantoolConnection>> multiConnection(InetSocketAddress serverAddress, int connections) {
        return Stream.generate(() -> serverAddress).map(this::singleConnection).limit(connections).collect(Collectors.toList());
    }
}

