/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.AbstractResultMapper;
import io.tarantool.driver.mappers.DefaultMessagePackMapper;
import io.tarantool.driver.mappers.InterfaceParameterClassNotFoundException;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.ValueConverter;
import org.msgpack.value.ArrayValue;

public abstract class AbstractResultMapperFactory<O, T extends AbstractResultMapper<? extends O>> {
    protected final MessagePackMapper messagePackMapper;

    public AbstractResultMapperFactory(MessagePackMapper messagePackMapper) {
        this.messagePackMapper = messagePackMapper;
    }

    public AbstractResultMapperFactory() {
        this.messagePackMapper = new DefaultMessagePackMapper();
    }

    protected abstract T createMapper(ValueConverter<ArrayValue, ? extends O> var1, Class<? extends O> var2);

    public T withConverter(ValueConverter<ArrayValue, ? extends O> valueConverter) {
        try {
            return this.withConverter(MapperReflectionUtils.getConverterTargetType(valueConverter), valueConverter);
        }
        catch (InterfaceParameterClassNotFoundException e) {
            throw new TarantoolClientException(e);
        }
    }

    public T withConverter(Class<? extends O> resultClass, ValueConverter<ArrayValue, ? extends O> valueConverter) {
        return this.createMapper(valueConverter, resultClass);
    }
}

