/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolMetadataRequestException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolMetadataContainer;
import io.tarantool.driver.metadata.TarantoolMetadataProvider;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.Value;

public class ProxyMetadataProvider
implements TarantoolMetadataProvider {
    private final String metadataFunctionName;
    private final TarantoolCallOperations client;
    private final ValueConverter<Value, TarantoolMetadataContainer> metadataConverter;
    private final Class<? extends SingleValueCallResult<TarantoolMetadataContainer>> resultClass;

    public ProxyMetadataProvider(TarantoolCallOperations client, String metadataFunctionName, ValueConverter<Value, TarantoolMetadataContainer> metadataConverter, Class<? extends SingleValueCallResult<TarantoolMetadataContainer>> resultClass) {
        this.metadataFunctionName = metadataFunctionName;
        this.client = client;
        this.metadataConverter = metadataConverter;
        this.resultClass = resultClass;
    }

    @Override
    public CompletableFuture<TarantoolMetadataContainer> getMetadata() {
        CallResultMapper<TarantoolMetadataContainer, SingleValueCallResult<TarantoolMetadataContainer>> mapper = this.client.getResultMapperFactoryFactory().singleValueResultMapperFactory(TarantoolMetadataContainer.class).withSingleValueResultConverter(this.metadataConverter, this.resultClass);
        return this.client.callForSingleResult(this.metadataFunctionName, mapper).exceptionally(ex -> {
            if (ex.getCause() != null && ex.getCause() instanceof TarantoolClientException) {
                throw new TarantoolMetadataRequestException(this.metadataFunctionName, (Throwable)ex);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException((Throwable)ex);
        });
    }
}

