/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.exceptions.TarantoolDecoderException;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolHeader;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessagePacker;

public class TarantoolRequest {
    private static AtomicLong syncId = new AtomicLong(0L);
    private static Supplier<Long> syncIdSupplier = () -> syncId.updateAndGet(n -> n >= Long.MAX_VALUE ? 1L : n + 1L);
    private TarantoolHeader header;
    private TarantoolRequestBody body;

    public TarantoolRequest(TarantoolRequestType type, TarantoolRequestBody body) {
        this.header = new TarantoolHeader(syncIdSupplier.get(), type.getCode());
        this.body = body;
    }

    public TarantoolHeader getHeader() {
        return this.header;
    }

    public Packable getBody() {
        return this.body;
    }

    public void toMessagePack(MessagePacker packer, MessagePackObjectMapper mapper) throws TarantoolDecoderException {
        try {
            packer.packValue(this.header.toMessagePackValue(mapper));
            packer.packValue(this.body.toMessagePackValue(mapper));
        }
        catch (IOException | MessagePackException e) {
            throw new TarantoolDecoderException(this.header, (Exception)e);
        }
    }
}

