/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.proxy.ProxyOperation;
import java.util.List;
import java.util.concurrent.CompletableFuture;

abstract class AbstractProxyOperation<T>
implements ProxyOperation<T> {
    protected final TarantoolCallOperations client;
    protected final String functionName;
    protected final List<?> arguments;
    private final MessagePackObjectMapper argumentsMapper;
    protected final CallResultMapper<T, SingleValueCallResult<T>> resultMapper;

    AbstractProxyOperation(TarantoolCallOperations client, String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
        this.client = client;
        this.argumentsMapper = argumentsMapper;
        this.arguments = arguments;
        this.functionName = functionName;
        this.resultMapper = resultMapper;
    }

    public TarantoolCallOperations getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    public CallResultMapper<T, SingleValueCallResult<T>> getResultMapper() {
        return this.resultMapper;
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.client.callForSingleResult(this.functionName, this.arguments, this.argumentsMapper, this.resultMapper);
    }
}

