/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import io.tarantool.driver.proxy.AbstractProxyOperation;
import io.tarantool.driver.proxy.CRUDOperationOptions;
import java.util.Arrays;
import java.util.List;

public final class UpdateProxyOperation<T>
extends AbstractProxyOperation<T> {
    UpdateProxyOperation(TarantoolCallOperations client, String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
        super(client, functionName, arguments, argumentsMapper, resultMapper);
    }

    public static final class Builder<T> {
        private TarantoolCallOperations client;
        private String spaceName;
        private String functionName;
        private TarantoolIndexQuery indexQuery;
        private TupleOperations operations;
        private MessagePackObjectMapper argumentsMapper;
        private CallResultMapper<T, SingleValueCallResult<T>> resultMapper;
        private int requestTimeout;

        public Builder<T> withClient(TarantoolCallOperations client) {
            this.client = client;
            return this;
        }

        public Builder<T> withSpaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public Builder<T> withFunctionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder<T> withIndexQuery(TarantoolIndexQuery indexQuery) {
            this.indexQuery = indexQuery;
            return this;
        }

        public Builder<T> withTupleOperation(TupleOperations operations) {
            this.operations = operations;
            return this;
        }

        public Builder<T> withArgumentsMapper(MessagePackObjectMapper argumentsMapper) {
            this.argumentsMapper = argumentsMapper;
            return this;
        }

        public Builder<T> withResultMapper(CallResultMapper<T, SingleValueCallResult<T>> resultMapper) {
            this.resultMapper = resultMapper;
            return this;
        }

        public Builder<T> withRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public UpdateProxyOperation<T> build() {
            CRUDOperationOptions options = CRUDOperationOptions.builder().withTimeout(this.requestTimeout).build();
            List<Object> arguments = Arrays.asList(this.spaceName, this.indexQuery.getKeyValues(), this.operations.asProxyOperationList(), options.asMap());
            return new UpdateProxyOperation<T>(this.client, this.functionName, arguments, this.argumentsMapper, this.resultMapper);
        }
    }
}

