/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.RequestRetryPolicy;
import io.tarantool.driver.RequestRetryPolicyFactory;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.utils.Assert;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class TarantoolRequestRetryPolicies {
    private static final Function<Throwable, Boolean> retryAll = t -> true;

    private TarantoolRequestRetryPolicies() {
    }

    public static AttemptsBoundRetryPolicyFactory.Builder<Function<Throwable, Boolean>> byNumberOfAttempts(int numberOfAttempts) {
        return TarantoolRequestRetryPolicies.byNumberOfAttempts(numberOfAttempts, retryAll);
    }

    public static <T extends Function<Throwable, Boolean>> AttemptsBoundRetryPolicyFactory.Builder<T> byNumberOfAttempts(int numberOfAttempts, T exceptionCheck) {
        return AttemptsBoundRetryPolicyFactory.builder(numberOfAttempts, exceptionCheck);
    }

    public static <T extends Function<Throwable, Boolean>> InfiniteRetryPolicyFactory.Builder<T> unbound() {
        return TarantoolRequestRetryPolicies.unbound(retryAll);
    }

    public static <T extends Function<Throwable, Boolean>> InfiniteRetryPolicyFactory.Builder<T> unbound(T exceptionCheck) {
        return InfiniteRetryPolicyFactory.builder(exceptionCheck);
    }

    public static final class AttemptsBoundRetryPolicyFactory<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicyFactory {
        private final int numberOfAttempts;
        private final T callback;
        private final long delay;
        private final long timeout;

        public AttemptsBoundRetryPolicyFactory(int numberOfAttempts, long timeout, long delay, T callback) {
            this.numberOfAttempts = numberOfAttempts;
            this.timeout = timeout;
            this.delay = delay;
            this.callback = callback;
        }

        public static <T extends Function<Throwable, Boolean>> Builder<T> builder(int attempts, T callback) {
            return new Builder<T>(attempts, callback);
        }

        @Override
        public RequestRetryPolicy create() {
            return new AttemptsBoundRetryPolicy<T>(this.numberOfAttempts, this.timeout, this.delay, this.callback);
        }

        public static class Builder<T extends Function<Throwable, Boolean>> {
            private final int numberOfAttempts;
            private long timeout = TimeUnit.HOURS.toMillis(1L);
            private long delay;
            private final T callback;

            public Builder(int numberOfAttempts, T callback) {
                this.numberOfAttempts = numberOfAttempts;
                this.callback = callback;
            }

            public Builder<T> withTimeout(long timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder<T> withDelay(long delay) {
                this.delay = delay;
                return this;
            }

            public AttemptsBoundRetryPolicyFactory<T> build() {
                return new AttemptsBoundRetryPolicyFactory<T>(this.numberOfAttempts, this.timeout, this.delay, this.callback);
            }
        }
    }

    public static final class AttemptsBoundRetryPolicy<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicy {
        private int attempts;
        private final long timeout;
        private final long delay;
        private final T callback;

        @Override
        public long getOperationTimeout() {
            return this.timeout;
        }

        public AttemptsBoundRetryPolicy(int attempts, long timeout, long delay, T callback) {
            Assert.state(attempts >= 0, "Attempts must be greater or equal than 0!");
            Assert.state(timeout >= 0L, "Timeout must be greater or equal than 0!");
            Assert.state(delay >= 0L, "Timeout must be greater or equal than 0!");
            Assert.notNull(callback, "Callback must not be null!");
            this.attempts = attempts;
            this.timeout = timeout;
            this.delay = delay;
            this.callback = callback;
        }

        @Override
        public boolean canRetryRequest(Throwable throwable) {
            if (((Boolean)this.callback.apply((Throwable)throwable)).booleanValue() && this.attempts > 0) {
                --this.attempts;
                if (this.delay > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.delay);
                    }
                    catch (InterruptedException e) {
                        throw new TarantoolClientException("Request retry delay has been interrupted");
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static final class InfiniteRetryPolicyFactory<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicyFactory {
        private final T callback;
        private final long delay;
        private final long timeout;

        public InfiniteRetryPolicyFactory(long timeout, long delay, T callback) {
            this.callback = callback;
            this.delay = delay;
            this.timeout = timeout;
        }

        public static <T extends Function<Throwable, Boolean>> Builder<T> builder(T callback) {
            return new Builder<T>(callback);
        }

        @Override
        public RequestRetryPolicy create() {
            return new InfiniteRetryPolicy<T>(this.timeout, this.delay, this.callback);
        }

        public static class Builder<T extends Function<Throwable, Boolean>> {
            private long timeout = TimeUnit.HOURS.toMillis(1L);
            private long delay;
            private final T callback;

            public Builder(T callback) {
                this.callback = callback;
            }

            public Builder<T> withTimeout(long timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder<T> withDelay(long delay) {
                this.delay = delay;
                return this;
            }

            public InfiniteRetryPolicyFactory<T> build() {
                return new InfiniteRetryPolicyFactory<T>(this.timeout, this.delay, this.callback);
            }
        }
    }

    public static final class InfiniteRetryPolicy<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicy {
        private final long timeout;
        private final long delay;
        private final T callback;

        public InfiniteRetryPolicy(long timeout, long delay, T callback) {
            Assert.state(timeout >= 0L, "Timeout must be greater or equal than 0!");
            Assert.state(delay >= 0L, "Timeout must be greater or equal than 0!");
            Assert.notNull(callback, "Callback must not be null!");
            this.timeout = timeout;
            this.delay = delay;
            this.callback = callback;
        }

        @Override
        public boolean canRetryRequest(Throwable throwable) {
            if (((Boolean)this.callback.apply((Throwable)throwable)).booleanValue()) {
                if (this.delay > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.delay);
                    }
                    catch (InterruptedException e) {
                        throw new TarantoolClientException("Request retry delay has been interrupted");
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public long getOperationTimeout() {
            return this.timeout;
        }
    }
}

