/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.exceptions.TarantoolFunctionCallException;
import io.tarantool.driver.mappers.ValueConverter;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class SingleValueCallResultImpl<T>
implements SingleValueCallResult<T> {
    private final T value;

    public SingleValueCallResultImpl(ArrayValue result, ValueConverter<Value, T> valueConverter) {
        if (result == null) {
            throw new TarantoolFunctionCallException("Function call result is null");
        }
        if (result.size() == 0 || result.size() == 1 && result.get(0).isNilValue()) {
            this.value = null;
        } else {
            if (result.size() == 2 && result.get(0).isNilValue() && !result.get(1).isNilValue()) {
                if (result.get(1).isMapValue()) {
                    throw new TarantoolFunctionCallException(result.get(1).asMapValue());
                }
                throw new TarantoolFunctionCallException(result.get(1).toString());
            }
            this.value = valueConverter.fromValue(result.get(0));
        }
    }

    @Override
    public T value() {
        return this.value;
    }
}

