/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.conditions;

import io.tarantool.driver.api.conditions.FieldIdentifier;
import io.tarantool.driver.exceptions.TarantoolFieldNotFoundException;
import io.tarantool.driver.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.utils.Assert;
import java.util.Optional;

public class NamedField
implements FieldIdentifier<TarantoolFieldMetadata, String> {
    private String name;

    public NamedField(String name) {
        Assert.hasText(name, "Field name should not be empty");
        this.name = name;
    }

    @Override
    public TarantoolFieldMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolFieldMetadata> fieldMetadata = spaceMetadata.getFieldByName(this.name);
        if (!fieldMetadata.isPresent()) {
            throw new TarantoolFieldNotFoundException(this.name, spaceMetadata);
        }
        return fieldMetadata.get();
    }

    @Override
    public String toIdentifier() {
        return this.name;
    }
}

