/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.conditions;

import io.tarantool.driver.api.conditions.FieldIdentifier;
import io.tarantool.driver.exceptions.TarantoolFieldNotFoundException;
import io.tarantool.driver.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.utils.Assert;
import java.util.Optional;

public class PositionField
implements FieldIdentifier<TarantoolFieldMetadata, Integer> {
    private int position;

    public PositionField(int position) {
        Assert.state(position >= 0, "Field position must be greater or equal 0");
        this.position = position;
    }

    @Override
    public TarantoolFieldMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolFieldMetadata> fieldMetadata = spaceMetadata.getFieldByPosition(this.position);
        if (!fieldMetadata.isPresent()) {
            throw new TarantoolFieldNotFoundException(this.position, spaceMetadata);
        }
        return fieldMetadata.get();
    }

    @Override
    public Integer toIdentifier() {
        return this.position;
    }
}

