/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolClusterAddressProvider;
import io.tarantool.driver.cluster.TarantoolClusterDiscoveryEndpoint;
import io.tarantool.driver.utils.Assert;

public class BinaryClusterDiscoveryEndpoint
implements TarantoolClusterDiscoveryEndpoint {
    private TarantoolClusterAddressProvider endpointProvider;
    private TarantoolClientConfig clientConfig = TarantoolClientConfig.builder().build();
    private String discoveryFunction;

    public TarantoolClusterAddressProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    public void setEndpointProvider(TarantoolClusterAddressProvider endpointProvider) {
        this.endpointProvider = endpointProvider;
    }

    public TarantoolClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(TarantoolClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public String getDiscoveryFunction() {
        return this.discoveryFunction;
    }

    public void setDiscoveryFunction(String discoveryFunction) {
        this.discoveryFunction = discoveryFunction;
    }

    public static class Builder {
        private BinaryClusterDiscoveryEndpoint endpoint = new BinaryClusterDiscoveryEndpoint();

        public Builder withEntryFunction(String discoveryFunction) {
            Assert.hasText(discoveryFunction, "The discovery function name should not be null or empty");
            this.endpoint.setDiscoveryFunction(discoveryFunction);
            return this;
        }

        public Builder withEndpointProvider(TarantoolClusterAddressProvider endpointProvider) {
            Assert.notNull(endpointProvider, "Discovery endpoint address provider should not be null");
            this.endpoint.setEndpointProvider(endpointProvider);
            return this;
        }

        public Builder withClientConfig(TarantoolClientConfig clientConfig) {
            Assert.notNull(clientConfig, "Client config should not be null");
            this.endpoint.setClientConfig(clientConfig);
            return this;
        }

        public BinaryClusterDiscoveryEndpoint build() {
            return this.endpoint;
        }
    }
}

