/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.ConnectionSelectionStrategy;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.core.ConnectionMode;
import io.tarantool.driver.core.TarantoolConnection;
import io.tarantool.driver.core.TarantoolConnectionFactory;
import io.tarantool.driver.core.TarantoolConnectionListeners;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.NoAvailableConnectionsException;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolConnectionException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTarantoolConnectionManager
implements TarantoolConnectionManager {
    private final TarantoolClientConfig config;
    private final TarantoolConnectionFactory connectionFactory;
    private final ConnectionSelectionStrategyFactory selectStrategyFactory;
    private final TarantoolConnectionListeners connectionListeners;
    private final AtomicReference<Map<TarantoolServerAddress, List<TarantoolConnection>>> connectionRegistry = new AtomicReference(new HashMap());
    private final AtomicReference<ConnectionSelectionStrategy> connectionSelectStrategy = new AtomicReference();
    private final AtomicReference<ConnectionMode> connectionMode = new AtomicReference<ConnectionMode>(ConnectionMode.FULL);
    private final Phaser initPhaser = new Phaser(0);
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected AbstractTarantoolConnectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, ConnectionSelectionStrategyFactory selectionStrategyFactory, TarantoolConnectionListeners connectionListeners) {
        this(config, connectionFactory, connectionListeners);
    }

    public AbstractTarantoolConnectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, TarantoolConnectionListeners connectionListeners) {
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.selectStrategyFactory = config.getConnectionSelectionStrategyFactory();
        this.connectionSelectStrategy.set(this.selectStrategyFactory.create(config, Collections.emptyList()));
        this.connectionListeners = connectionListeners;
    }

    protected abstract Collection<TarantoolServerAddress> getAddresses();

    @Override
    public CompletableFuture<TarantoolConnection> getConnection() {
        return this.getConnectionInternal().handle((connection, ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                if (ex instanceof NoAvailableConnectionsException) {
                    this.connectionMode.set(ConnectionMode.FULL);
                }
                throw new TarantoolConnectionException((Throwable)ex);
            }
            return connection;
        });
    }

    private CompletableFuture<TarantoolConnection> getConnectionInternal() {
        CompletionStage<TarantoolConnection> result;
        ConnectionMode currentMode = this.connectionMode.get();
        if (this.initPhaser.getRegisteredParties() == 0 && (this.connectionMode.compareAndSet(ConnectionMode.FULL, ConnectionMode.OFF) || this.connectionMode.compareAndSet(ConnectionMode.PARTIAL, ConnectionMode.OFF))) {
            if (currentMode == ConnectionMode.FULL) {
                this.initPhaser.register();
            }
            result = ((CompletableFuture)((CompletableFuture)this.establishConnections().thenAccept(registry -> {
                if (currentMode == ConnectionMode.PARTIAL) {
                    this.initPhaser.register();
                }
                this.connectionRegistry.set((Map<TarantoolServerAddress, List<TarantoolConnection>>)registry);
                ConnectionSelectionStrategy strategy = this.selectStrategyFactory.create(this.config, registry.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                this.connectionSelectStrategy.set(strategy);
            })).thenApply(v -> this.connectionSelectStrategy.get().next())).whenComplete((v, ex) -> {
                if (ex != null) {
                    this.connectionMode.set(currentMode);
                }
                this.initPhaser.arriveAndDeregister();
            });
        } else {
            this.initPhaser.awaitAdvance(this.initPhaser.getPhase());
            result = new CompletableFuture<TarantoolConnection>();
            try {
                result.complete(this.connectionSelectStrategy.get().next());
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }
        return result;
    }

    private CompletableFuture<Map<TarantoolServerAddress, List<TarantoolConnection>>> establishConnections() throws TarantoolClientException {
        CompletionStage<Map<TarantoolServerAddress, List<TarantoolConnection>>> result = new CompletableFuture<Map<TarantoolServerAddress, List<TarantoolConnection>>>();
        try {
            List<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> endpointConnections = this.getConnections();
            result = CompletableFuture.allOf(endpointConnections.toArray(new CompletableFuture[0])).thenApply(v -> endpointConnections.parallelStream().map(CompletableFuture::join).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private List<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> getConnections() {
        Collection<TarantoolServerAddress> addresses = this.getAddresses();
        ArrayList<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> endpointConnections = new ArrayList<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>>(addresses.size());
        block2: for (TarantoolServerAddress serverAddress : addresses) {
            List<TarantoolConnection> aliveConnections = this.getAliveConnections(serverAddress);
            if (aliveConnections.size() < this.config.getConnections()) {
                CompletionStage connectionFuture = this.establishConnectionsToEndpoint(serverAddress, this.config.getConnections() - aliveConnections.size()).thenApply(connections -> {
                    connections.addAll(aliveConnections);
                    return new AbstractMap.SimpleEntry<TarantoolServerAddress, List>(serverAddress, (List)connections);
                });
                endpointConnections.add((CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>)connectionFuture);
                continue;
            }
            if (aliveConnections.size() > this.config.getConnections()) {
                int count = this.config.getConnections() - aliveConnections.size();
                for (TarantoolConnection aliveConnection : aliveConnections) {
                    if (count-- <= 0) continue block2;
                    try {
                        aliveConnection.close();
                    }
                    catch (Exception e) {
                        this.logger.info("Failed to close the connection: {}", (Object)e.getMessage());
                    }
                }
                continue;
            }
            endpointConnections.add(CompletableFuture.completedFuture(new AbstractMap.SimpleEntry<TarantoolServerAddress, List<TarantoolConnection>>(serverAddress, aliveConnections)));
        }
        return endpointConnections;
    }

    private List<TarantoolConnection> getAliveConnections(TarantoolServerAddress serverAddress) {
        List connections = this.connectionRegistry.get().getOrDefault(serverAddress, Collections.emptyList());
        return connections.stream().filter(TarantoolConnection::isConnected).collect(Collectors.toList());
    }

    private CompletableFuture<List<TarantoolConnection>> establishConnectionsToEndpoint(TarantoolServerAddress serverAddress, int connectionCount) {
        List<CompletableFuture> connections = this.connectionFactory.multiConnection(serverAddress.getSocketAddress(), connectionCount, this.connectionListeners).stream().peek(cf -> cf.thenApply(conn -> {
            if (conn.isConnected()) {
                this.logger.info("Connected to Tarantool server at {}", (Object)conn.getRemoteAddress());
            }
            conn.addConnectionFailureListener((c, ex) -> {
                this.connectionMode.set(ConnectionMode.PARTIAL);
                try {
                    c.close();
                }
                catch (Exception e) {
                    this.logger.info("Failed to close the connection: {}", (Object)e.getMessage());
                }
            });
            conn.addConnectionCloseListener(c -> this.logger.info("Disconnected from {}", (Object)c.getRemoteAddress()));
            return conn;
        })).collect(Collectors.toList());
        return CompletableFuture.allOf(connections.toArray(new CompletableFuture[0])).thenApply(v -> connections.parallelStream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public void close() {
        if (this.initPhaser.getRegisteredParties() > 0) {
            this.initPhaser.awaitAdvance(this.initPhaser.getPhase());
        }
        this.connectionRegistry.get().values().stream().flatMap(Collection::stream).forEach(conn -> {
            try {
                conn.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close connection: {}", (Object)e.getMessage());
            }
        });
    }
}

