/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.auth.ChapSha1TarantoolAuthenticator;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.codecs.MessagePackFrameDecoder;
import io.tarantool.driver.codecs.MessagePackFrameEncoder;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.handlers.TarantoolAuthenticationHandler;
import io.tarantool.driver.handlers.TarantoolAuthenticationResponseHandler;
import io.tarantool.driver.handlers.TarantoolRequestHandler;
import io.tarantool.driver.handlers.TarantoolResponseHandler;
import io.tarantool.driver.mappers.DefaultMessagePackMapperFactory;
import java.util.concurrent.CompletableFuture;

public class TarantoolChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private TarantoolClientConfig config;
    private TarantoolVersionHolder versionHolder;
    private CompletableFuture<Channel> connectionFuture;
    private RequestFutureManager futureManager;

    public TarantoolChannelInitializer(TarantoolClientConfig config, RequestFutureManager futureManager, TarantoolVersionHolder versionHolder, CompletableFuture<Channel> connectionFuture) {
        this.config = config;
        this.versionHolder = versionHolder;
        this.connectionFuture = connectionFuture;
        this.futureManager = futureManager;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        socketChannel.pipeline().addLast("TarantoolAuthenticationHandler", new TarantoolAuthenticationHandler<SimpleTarantoolCredentials, ChapSha1TarantoolAuthenticator>(this.connectionFuture, this.versionHolder, (SimpleTarantoolCredentials)this.config.getCredentials(), new ChapSha1TarantoolAuthenticator())).addLast("MessagePackFrameDecoder", (ChannelHandler)new MessagePackFrameDecoder()).addLast("MessagePackFrameEncoder", (ChannelHandler)new MessagePackFrameEncoder(DefaultMessagePackMapperFactory.getInstance().defaultComplexTypesMapper())).addLast("TarantoolRequestHandler", (ChannelHandler)new TarantoolRequestHandler(this.futureManager)).addLast("TarantoolAuthenticationResponseHandler", (ChannelHandler)new TarantoolAuthenticationResponseHandler(this.connectionFuture)).addLast("TarantoolResponseHandler", (ChannelHandler)new TarantoolResponseHandler(this.futureManager));
    }
}

