/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.exceptions;

import io.tarantool.driver.exceptions.TarantoolException;
import java.util.Map;
import org.msgpack.value.MapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class TarantoolFunctionCallException
extends TarantoolException {
    private static final StringValue ERROR_MESSAGE = ValueFactory.newString((String)"str");
    private static final StringValue STACKTRACE = ValueFactory.newString((String)"stack");
    private String errorMessage;
    private String stacktrace;

    public TarantoolFunctionCallException(String errorMessage) {
        super(errorMessage);
        this.errorMessage = errorMessage;
    }

    public TarantoolFunctionCallException(MapValue value) {
        Map error = value.map();
        this.errorMessage = ((Value)error.getOrDefault(ERROR_MESSAGE, value)).toString();
        this.stacktrace = error.containsKey(STACKTRACE) ? ((Value)error.get(STACKTRACE)).toString() : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TarantoolFunctionCallException: ");
        sb.append(this.errorMessage);
        if (this.stacktrace != null) {
            sb.append("\n").append(this.stacktrace);
        }
        return sb.toString();
    }
}

