/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.DefaultMultiValueResultMapper;
import io.tarantool.driver.mappers.DefaultSingleValueResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MultiValueListConverter;
import io.tarantool.driver.mappers.MultiValueResultMapperFactory;
import io.tarantool.driver.mappers.MultiValueTarantoolResultMapperFactory;
import io.tarantool.driver.mappers.ResultMapperFactoryFactory;
import io.tarantool.driver.mappers.SingleValueResultMapperFactory;
import io.tarantool.driver.mappers.SingleValueTarantoolResultMapperFactory;
import io.tarantool.driver.mappers.TarantoolTupleMultiResultMapperFactory;
import io.tarantool.driver.mappers.TarantoolTupleResultMapperFactory;
import io.tarantool.driver.mappers.TarantoolTupleSingleResultMapperFactory;
import io.tarantool.driver.mappers.TupleResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public final class DefaultResultMapperFactoryFactory
implements ResultMapperFactoryFactory {
    @Override
    public TarantoolTupleResultMapperFactory defaultTupleResultMapperFactory() {
        return new TarantoolTupleResultMapperFactory();
    }

    @Override
    public TarantoolTupleSingleResultMapperFactory defaultTupleSingleResultMapperFactory() {
        return new TarantoolTupleSingleResultMapperFactory();
    }

    @Override
    public TarantoolTupleMultiResultMapperFactory defaultTupleMultiResultMapperFactory() {
        return new TarantoolTupleMultiResultMapperFactory();
    }

    @Override
    public <T> TupleResultMapperFactory<T> tupleResultMapperFactory() {
        return new TupleResultMapperFactory();
    }

    @Override
    public <T> SingleValueResultMapperFactory<T> singleValueResultMapperFactory() {
        return new SingleValueResultMapperFactory();
    }

    @Override
    public <T> SingleValueTarantoolResultMapperFactory<T> singleValueTarantoolResultMapperFactory() {
        return new SingleValueTarantoolResultMapperFactory();
    }

    @Override
    public <T, R extends List<T>> MultiValueResultMapperFactory<T, R> multiValueResultMapperFactory() {
        return new MultiValueResultMapperFactory();
    }

    @Override
    public <T> MultiValueTarantoolResultMapperFactory<T> multiValueTarantoolResultMapperFactory() {
        return new MultiValueTarantoolResultMapperFactory();
    }

    public <T> CallResultMapper<T, SingleValueCallResult<T>> getSingleValueResultMapper(ValueConverter<Value, T> valueConverter) {
        return this.singleValueResultMapperFactory().withSingleValueResultConverter(valueConverter, SingleValueCallResult.class);
    }

    public <T, R extends List<T>> CallResultMapper<R, MultiValueCallResult<T, R>> getMultiValueResultMapper(Supplier<R> containerSupplier, ValueConverter<Value, T> valueConverter) {
        return this.multiValueResultMapperFactory().withMultiValueResultConverter(new MultiValueListConverter<T, R, Value>(valueConverter, containerSupplier), MultiValueCallResult.class);
    }

    public <T> CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> getTarantoolResultMapper(MessagePackMapper mapper, Class<T> tupleClass) {
        return this.singleValueTarantoolResultMapperFactory().withTarantoolResultConverter(this.getConverter(mapper, ArrayValue.class, tupleClass));
    }

    public <T, R extends List<T>> CallResultMapper<R, MultiValueCallResult<T, R>> getDefaultMultiValueMapper(MessagePackMapper mapper, Class<T> tupleClass) {
        return new DefaultMultiValueResultMapper(mapper, tupleClass);
    }

    public <T> CallResultMapper<T, SingleValueCallResult<T>> getDefaultSingleValueMapper(MessagePackMapper mapper, Class<T> tupleClass) {
        return new DefaultSingleValueResultMapper<T>(mapper, tupleClass);
    }

    private <V extends Value, T> ValueConverter<V, T> getConverter(MessagePackMapper mapper, Class<V> valueClass, Class<T> tupleClass) {
        Optional<ValueConverter<V, T>> converter = mapper.getValueConverter(valueClass, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No converter for value class %s and type %s is present", valueClass, tupleClass);
        }
        return converter.get();
    }
}

