/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.SpacesTarantoolMetadataContainer;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolIndexMetadataConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadataResult;
import io.tarantool.driver.metadata.TarantoolMetadataContainer;
import io.tarantool.driver.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.metadata.TarantoolSpaceMetadataConverter;
import io.tarantool.driver.metadata.TarantoolSpaceMetadataResult;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;

public class SpacesMetadataProvider
implements TarantoolMetadataProvider {
    static final String VSPACE_SELECT_CMD = "box.space._vspace:select";
    static final String VINDEX_SELECT_CMD = "box.space._vindex:select";
    private final TarantoolCallOperations client;
    private final TarantoolSpaceMetadataConverter spaceMetadataMapper;
    private final TarantoolIndexMetadataConverter indexMetadataMapper;

    public SpacesMetadataProvider(TarantoolCallOperations client, MessagePackMapper messagePackMapper) {
        this.client = client;
        this.spaceMetadataMapper = new TarantoolSpaceMetadataConverter(messagePackMapper);
        this.indexMetadataMapper = new TarantoolIndexMetadataConverter(messagePackMapper);
    }

    @Override
    public CompletableFuture<TarantoolMetadataContainer> getMetadata() throws TarantoolClientException {
        CompletableFuture<TarantoolResult<TarantoolSpaceMetadata>> spaces = this.select(VSPACE_SELECT_CMD, this.spaceMetadataMapper, TarantoolSpaceMetadataResult.class);
        CompletableFuture<TarantoolResult<TarantoolIndexMetadata>> indexes = this.select(VINDEX_SELECT_CMD, this.indexMetadataMapper, TarantoolIndexMetadataResult.class);
        return spaces.thenCombine(indexes, SpacesTarantoolMetadataContainer::new);
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(String selectCmd, ValueConverter<ArrayValue, T> resultConverter, Class<? extends SingleValueCallResult<TarantoolResult<T>>> resultClass) throws TarantoolClientException {
        CallResultMapper resultMapper = this.client.getResultMapperFactoryFactory().singleValueTarantoolResultMapperFactory().withTarantoolResultConverter(resultConverter, resultClass);
        return this.client.call(selectCmd, resultMapper);
    }
}

