/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataContainer;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import java.util.HashMap;
import java.util.Map;

public class SpacesTarantoolMetadataContainer
implements TarantoolMetadataContainer {
    private final Map<String, TarantoolSpaceMetadata> spaceMetadataByName = new HashMap<String, TarantoolSpaceMetadata>();
    private final Map<Integer, TarantoolSpaceMetadata> spaceMetadataById = new HashMap<Integer, TarantoolSpaceMetadata>();
    private final Map<String, Map<String, TarantoolIndexMetadata>> indexMetadataBySpaceName = new HashMap<String, Map<String, TarantoolIndexMetadata>>();

    public SpacesTarantoolMetadataContainer(TarantoolResult<TarantoolSpaceMetadata> spacesCollection, TarantoolResult<TarantoolIndexMetadata> indexesCollection) {
        spacesCollection.forEach(meta -> {
            this.spaceMetadataByName.put(meta.getSpaceName(), (TarantoolSpaceMetadata)meta);
            this.spaceMetadataById.put(meta.getSpaceId(), (TarantoolSpaceMetadata)meta);
        });
        indexesCollection.forEach(meta -> {
            String spaceName = this.spaceMetadataById.get(meta.getSpaceId()).getSpaceName();
            this.indexMetadataBySpaceName.putIfAbsent(spaceName, new HashMap());
            this.indexMetadataBySpaceName.get(spaceName).put(meta.getIndexName(), (TarantoolIndexMetadata)meta);
        });
    }

    @Override
    public Map<String, TarantoolSpaceMetadata> getSpaceMetadataByName() {
        return this.spaceMetadataByName;
    }

    @Override
    public Map<String, Map<String, TarantoolIndexMetadata>> getIndexMetadataBySpaceName() {
        return this.indexMetadataBySpaceName;
    }
}

