/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TarantoolUpdateRequest
extends TarantoolRequest {
    private TarantoolUpdateRequest(TarantoolRequestBody body) {
        super(TarantoolRequestType.IPROTO_UPDATE, body);
    }

    public static class Builder {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(4, 1.0f);
        TarantoolSpaceMetadata metadata;

        public Builder(TarantoolSpaceMetadata metadata) {
            this.metadata = metadata;
        }

        public Builder withSpaceId(int spaceId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode(), spaceId);
            return this;
        }

        public Builder withIndexId(int indexId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode(), indexId);
            return this;
        }

        public Builder withKeyValues(List<?> keyValues) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_KEY.getCode(), keyValues);
            return this;
        }

        public Builder withTupleOperations(TupleOperations operations) {
            operations.asList().forEach(op -> {
                if (op.getFieldIndex() == null) {
                    op.setFieldIndex(this.metadata.getFieldPositionByName(op.getFieldName()));
                }
            });
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_TUPLE.getCode(), operations.asList());
            return this;
        }

        public TarantoolUpdateRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode())) {
                throw new TarantoolProtocolException("Space ID must be specified in the update request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode())) {
                throw new TarantoolProtocolException("Index ID must be specified in the update request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_KEY.getCode())) {
                throw new TarantoolProtocolException("Key values must be specified in the update request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_TUPLE.getCode())) {
                throw new TarantoolProtocolException("Update operations must be specified for the update request");
            }
            return new TarantoolUpdateRequest(new TarantoolRequestBody(this.bodyMap, mapper));
        }
    }
}

