/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.protocol.Packable;
import java.util.HashMap;
import java.util.Map;

public final class CRUDOperationOptions {
    public static final String TIMEOUT = "timeout";
    public static final String SELECT_LIMIT = "first";
    public static final String SELECT_AFTER = "after";
    public static final String SELECT_BATCH_SIZE = "batch_size";
    private final Integer timeout;
    private final Long selectLimit;
    private final Long selectBatchSize;
    private final Packable after;
    private final Map<String, Object> resultMap = new HashMap<String, Object>(4, 1.0f);

    private CRUDOperationOptions(Builder builder) {
        this.timeout = builder.timeout;
        this.selectLimit = builder.selectLimit;
        this.after = builder.after;
        this.selectBatchSize = builder.selectBatchSize;
        this.initResultMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initResultMap() {
        if (this.timeout != null) {
            this.resultMap.put(TIMEOUT, this.timeout);
        }
        if (this.selectLimit != null) {
            this.resultMap.put(SELECT_LIMIT, this.selectLimit);
        }
        if (this.after != null) {
            this.resultMap.put(SELECT_AFTER, this.after);
        }
        if (this.selectBatchSize != null) {
            this.resultMap.put(SELECT_BATCH_SIZE, this.selectBatchSize);
        }
    }

    public Map<String, Object> asMap() {
        return this.resultMap;
    }

    public static final class Builder {
        private Integer timeout;
        private Long selectLimit;
        private Packable after;
        private Long selectBatchSize;

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withSelectLimit(long selectLimit) {
            this.selectLimit = selectLimit;
            return this;
        }

        public Builder withSelectBatchSize(long selectBatchSize) {
            this.selectBatchSize = selectBatchSize;
            return this;
        }

        public Builder withSelectAfter(Packable startTuple) {
            this.after = startTuple;
            return this;
        }

        public CRUDOperationOptions build() {
            return new CRUDOperationOptions(this);
        }
    }
}

