/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.cursor;

import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.cursor.TarantoolCursorBase;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.protocol.Packable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;

public class StartAfterCursor<T extends Packable, R extends Collection<T>>
extends TarantoolCursorBase<T, R> {
    private final TarantoolSpaceOperations<T, R> space;
    private final Conditions initConditions;
    private final long batchSize;
    private long spaceOffset;
    private final MessagePackMapper mapper;
    private Iterator<T> resultIter = Collections.emptyIterator();
    private T currentValue;
    private T lastTuple;

    public StartAfterCursor(TarantoolSpaceOperations<T, R> space, Conditions conditions, int batchSize, MessagePackMapper mapper) {
        this.space = space;
        this.initConditions = conditions;
        this.batchSize = batchSize;
        this.spaceOffset = 0L;
        this.mapper = mapper;
    }

    @Override
    protected void fetchNextTuples() throws TarantoolClientException {
        long limit = StartAfterCursor.calcLimit(this.initConditions.getLimit(), this.batchSize, this.spaceOffset);
        if (limit <= 0L) {
            return;
        }
        Conditions conditions = new Conditions(this.initConditions).withLimit(limit);
        if (this.lastTuple != null) {
            conditions.startAfter(this.lastTuple, this.mapper::toValue);
        }
        try {
            this.resultIter = ((Collection)this.space.select(conditions).get()).iterator();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    protected boolean advanceIterator() {
        if (this.resultIter.hasNext()) {
            this.currentValue = (Packable)this.resultIter.next();
            ++this.spaceOffset;
            return true;
        }
        if (this.currentValue != null) {
            this.lastTuple = this.currentValue;
            this.currentValue = null;
        }
        return false;
    }

    @Override
    protected T getCurrentValue() {
        return this.currentValue;
    }
}

