/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.retry;

import io.tarantool.driver.api.retry.RequestRetryPolicy;
import io.tarantool.driver.api.retry.RequestRetryPolicyFactory;
import io.tarantool.driver.exceptions.TarantoolAttemptsLimitException;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolConnectionException;
import io.tarantool.driver.exceptions.TarantoolInternalNetworkException;
import io.tarantool.driver.exceptions.TarantoolTimeoutException;
import io.tarantool.driver.utils.Assert;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TarantoolRequestRetryPolicies {
    public static final Function<Throwable, Boolean> retryAll = t -> true;
    public static final Function<Throwable, Boolean> retryNone = t -> false;
    public static final long DEFAULT_ONE_HOUR_TIMEOUT = TimeUnit.HOURS.toMillis(1L);

    public static <T extends Function<Throwable, Boolean>> Function<Throwable, Boolean> withRetryingNetworkErrors(T exceptionCheck) {
        return e -> {
            boolean retryRequest = false;
            Boolean userExceptionCheck = (Boolean)exceptionCheck.apply(e);
            if (e instanceof TimeoutException || e instanceof TarantoolConnectionException || e instanceof TarantoolInternalNetworkException) {
                retryRequest = true;
            }
            return retryRequest || userExceptionCheck != false;
        };
    }

    public static Function<Throwable, Boolean> retryNetworkErrors() {
        return TarantoolRequestRetryPolicies.withRetryingNetworkErrors(retryNone);
    }

    private TarantoolRequestRetryPolicies() {
    }

    public static AttemptsBoundRetryPolicyFactory.Builder<Function<Throwable, Boolean>> byNumberOfAttempts(int numberOfAttempts) {
        return TarantoolRequestRetryPolicies.byNumberOfAttempts(numberOfAttempts, TarantoolRequestRetryPolicies.retryNetworkErrors());
    }

    public static <T extends Function<Throwable, Boolean>> AttemptsBoundRetryPolicyFactory.Builder<T> byNumberOfAttempts(int numberOfAttempts, T exceptionCheck) {
        return AttemptsBoundRetryPolicyFactory.builder(numberOfAttempts, exceptionCheck);
    }

    public static <T extends Function<Throwable, Boolean>> InfiniteRetryPolicyFactory.Builder<T> unbound() {
        return TarantoolRequestRetryPolicies.unbound(TarantoolRequestRetryPolicies.retryNetworkErrors());
    }

    public static <T extends Function<Throwable, Boolean>> InfiniteRetryPolicyFactory.Builder<T> unbound(T exceptionCheck) {
        return InfiniteRetryPolicyFactory.builder(exceptionCheck);
    }

    public static final class AttemptsBoundRetryPolicyFactory<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicyFactory {
        private final int numberOfAttempts;
        private final T exceptionCheck;
        private final long delay;
        private final long requestTimeout;

        public AttemptsBoundRetryPolicyFactory(int numberOfAttempts, long requestTimeout, long delay, T exceptionCheck) {
            this.numberOfAttempts = numberOfAttempts;
            this.requestTimeout = requestTimeout;
            this.delay = delay;
            this.exceptionCheck = exceptionCheck;
        }

        public static <T extends Function<Throwable, Boolean>> Builder<T> builder(int attempts, T exceptionCheck) {
            return new Builder<T>(attempts, exceptionCheck);
        }

        @Override
        public RequestRetryPolicy create() {
            return new AttemptsBoundRetryPolicy<T>(this.numberOfAttempts, this.requestTimeout, this.delay, this.exceptionCheck);
        }

        public int getNumberOfAttempts() {
            return this.numberOfAttempts;
        }

        public T getExceptionCheck() {
            return this.exceptionCheck;
        }

        public long getDelay() {
            return this.delay;
        }

        public long getRequestTimeout() {
            return this.requestTimeout;
        }

        public static class Builder<T extends Function<Throwable, Boolean>> {
            private final int numberOfAttempts;
            private long requestTimeout = DEFAULT_ONE_HOUR_TIMEOUT;
            private long delay;
            private final T exceptionCheck;

            public Builder(int numberOfAttempts, T exceptionCheck) {
                this.numberOfAttempts = numberOfAttempts;
                this.exceptionCheck = exceptionCheck;
            }

            public Builder<T> withRequestTimeout(long requestTimeout) {
                this.requestTimeout = requestTimeout;
                return this;
            }

            public Builder<T> withDelay(long delay) {
                this.delay = delay;
                return this;
            }

            public AttemptsBoundRetryPolicyFactory<T> build() {
                return new AttemptsBoundRetryPolicyFactory<T>(this.numberOfAttempts, this.requestTimeout, this.delay, this.exceptionCheck);
            }
        }
    }

    public static final class AttemptsBoundRetryPolicy<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicy {
        private int attempts;
        private final int limit;
        private final long requestTimeout;
        private final long delay;
        private final T exceptionCheck;

        @Override
        public long getRequestTimeout() {
            return this.requestTimeout;
        }

        public AttemptsBoundRetryPolicy(int attempts, long requestTimeout, long delay, T exceptionCheck) {
            Assert.state(attempts >= 0, "Attempts must be greater or equal than 0!");
            Assert.state(requestTimeout >= 0L, "Timeout must be greater or equal than 0!");
            Assert.state(delay >= 0L, "Timeout must be greater or equal than 0!");
            Assert.notNull(exceptionCheck, "Exception checking callback must not be null!");
            this.attempts = attempts;
            this.limit = attempts;
            this.requestTimeout = requestTimeout;
            this.delay = delay;
            this.exceptionCheck = exceptionCheck;
        }

        @Override
        public boolean canRetryRequest(Throwable throwable) {
            if (((Boolean)this.exceptionCheck.apply((Throwable)throwable)).booleanValue() && this.attempts > 0) {
                --this.attempts;
                if (this.delay > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.delay);
                    }
                    catch (InterruptedException e) {
                        throw new TarantoolClientException("Request retry delay has been interrupted");
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public <T> CompletableFuture<T> wrapOperation(Supplier<CompletableFuture<T>> operation, Executor executor) {
            Assert.notNull(operation, "Operation must not be null");
            Assert.notNull(executor, "Executor must not be null");
            return CompletableFuture.supplyAsync(() -> {
                Throwable ex;
                do {
                    try {
                        return ((CompletableFuture)operation.get()).get(this.getRequestTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        ex = e;
                    }
                    catch (ExecutionException e) {
                        ex = e.getCause();
                    }
                    if (this.attempts != 0) continue;
                    ex = new TarantoolAttemptsLimitException(this.limit, ex);
                    break;
                } while (this.canRetryRequest(ex));
                throw new CompletionException(ex);
            }, executor);
        }
    }

    public static final class InfiniteRetryPolicyFactory<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicyFactory {
        private final T callback;
        private final long delay;
        private final long requestTimeout;
        private final long operationTimeout;

        public InfiniteRetryPolicyFactory(long requestTimeout, long operationTimeout, long delay, T callback) {
            this.callback = callback;
            this.delay = delay;
            this.requestTimeout = requestTimeout;
            this.operationTimeout = operationTimeout;
        }

        public static <T extends Function<Throwable, Boolean>> Builder<T> builder(T callback) {
            return new Builder<T>(callback);
        }

        @Override
        public RequestRetryPolicy create() {
            return new InfiniteRetryPolicy<T>(this.requestTimeout, this.operationTimeout, this.delay, this.callback);
        }

        public T getCallback() {
            return this.callback;
        }

        public long getDelay() {
            return this.delay;
        }

        public long getRequestTimeout() {
            return this.requestTimeout;
        }

        public long getOperationTimeout() {
            return this.operationTimeout;
        }

        public static class Builder<T extends Function<Throwable, Boolean>> {
            private long requestTimeout = DEFAULT_ONE_HOUR_TIMEOUT;
            private long delay;
            private final T callback;
            private long operationTimeout = DEFAULT_ONE_HOUR_TIMEOUT;

            public Builder(T callback) {
                this.callback = callback;
            }

            public Builder<T> withRequestTimeout(long timeout) {
                this.requestTimeout = timeout;
                return this;
            }

            public Builder<T> withOperationTimeout(long operationTimeout) {
                this.operationTimeout = operationTimeout;
                return this;
            }

            public Builder<T> withDelay(long delay) {
                this.delay = delay;
                return this;
            }

            public InfiniteRetryPolicyFactory<T> build() {
                return new InfiniteRetryPolicyFactory<T>(this.requestTimeout, this.operationTimeout, this.delay, this.callback);
            }
        }
    }

    public static final class InfiniteRetryPolicy<T extends Function<Throwable, Boolean>>
    implements RequestRetryPolicy {
        private final long requestTimeout;
        private final long operationTimeout;
        private final long delay;
        private final T callback;

        public InfiniteRetryPolicy(long requestTimeout, long operationTimeout, long delay, T exceptionCheck) {
            Assert.state(requestTimeout >= 0L, "Timeout must be greater or equal than 0!");
            Assert.state(operationTimeout >= requestTimeout, "Operation timeout must be greater or equal than requestTimeout!");
            Assert.state(delay >= 0L, "Delay must be greater or equal than 0!");
            Assert.notNull(exceptionCheck, "Exception checking callback must not be null!");
            this.requestTimeout = requestTimeout;
            this.operationTimeout = operationTimeout;
            this.delay = delay;
            this.callback = exceptionCheck;
        }

        @Override
        public boolean canRetryRequest(Throwable throwable) {
            if (((Boolean)this.callback.apply((Throwable)throwable)).booleanValue()) {
                if (this.delay > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.delay);
                    }
                    catch (InterruptedException e) {
                        throw new TarantoolClientException("Request retry delay has been interrupted");
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public long getRequestTimeout() {
            return this.requestTimeout;
        }

        public long getOperationTimeout() {
            return this.operationTimeout;
        }

        @Override
        public <T> CompletableFuture<T> wrapOperation(Supplier<CompletableFuture<T>> operation, Executor executor) {
            Assert.notNull(operation, "Operation must not be null");
            Assert.notNull(executor, "Executor must not be null");
            return CompletableFuture.supplyAsync(() -> {
                Throwable ex;
                long timeElapsed = 0L;
                do {
                    long tStart = System.nanoTime();
                    try {
                        return ((CompletableFuture)operation.get()).get(this.getRequestTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        ex = e;
                    }
                    catch (ExecutionException e) {
                        ex = e.getCause();
                    }
                    if ((timeElapsed += (System.nanoTime() - tStart) / 1000000L) < this.getOperationTimeout()) continue;
                    ex = new TarantoolTimeoutException(timeElapsed, ex);
                    break;
                } while (this.canRetryRequest(ex));
                throw new CompletionException(ex);
            }, executor);
        }
    }
}

