/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import io.tarantool.driver.cluster.TarantoolClusterDiscoveryEndpoint;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.utils.Assert;

public final class TarantoolClusterDiscoveryConfig {
    private TarantoolClusterDiscoveryEndpoint endpoint;
    private int serviceDiscoveryDelay = 60000;

    public TarantoolClusterDiscoveryEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(TarantoolClusterDiscoveryEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public int getServiceDiscoveryDelay() {
        return this.serviceDiscoveryDelay;
    }

    public void setServiceDiscoveryDelay(int serviceDiscoveryDelay) {
        this.serviceDiscoveryDelay = serviceDiscoveryDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TarantoolClusterDiscoveryConfig config = new TarantoolClusterDiscoveryConfig();

        public Builder withDelay(int delay) {
            if (delay <= 0) {
                throw new IllegalArgumentException("Discovery delay must be greater than 0 ms");
            }
            this.config.setServiceDiscoveryDelay(delay);
            return this;
        }

        public Builder withEndpoint(TarantoolClusterDiscoveryEndpoint endpoint) {
            Assert.notNull(endpoint, "Cluster discovery endpoint config should not be null");
            this.config.setEndpoint(endpoint);
            return this;
        }

        public TarantoolClusterDiscoveryConfig build() {
            if (this.config.getEndpoint() == null) {
                throw new TarantoolClientException("Cluster discovery endpoint must be not null");
            }
            return this.config;
        }
    }
}

