/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolClusterAddressProvider;
import io.tarantool.driver.api.connection.TarantoolConnectionListeners;
import io.tarantool.driver.core.AbstractTarantoolClient;
import io.tarantool.driver.core.connection.TarantoolClusterConnectionManager;
import io.tarantool.driver.core.connection.TarantoolConnectionFactory;
import io.tarantool.driver.core.connection.TarantoolConnectionManager;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.utils.Assert;
import java.util.Collection;

public abstract class ClusterTarantoolClient<T extends Packable, R extends Collection<T>>
extends AbstractTarantoolClient<T, R> {
    private final TarantoolClusterAddressProvider addressProvider;

    public ClusterTarantoolClient(TarantoolClientConfig config, TarantoolClusterAddressProvider addressProvider) {
        super(config);
        Assert.notNull(addressProvider, "Address provider must not be null");
        this.addressProvider = addressProvider;
    }

    @Override
    protected TarantoolConnectionManager connectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, TarantoolConnectionListeners listeners) {
        return new TarantoolClusterConnectionManager(config, connectionFactory, listeners, this.addressProvider);
    }

    protected TarantoolClusterAddressProvider getAddressProvider() {
        return this.addressProvider;
    }
}

