/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.core.TarantoolRequestMetadata;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.protocol.TarantoolRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureManager
implements AutoCloseable {
    private final ScheduledExecutorService timeoutScheduler;
    private final TarantoolClientConfig config;
    private final Map<Long, TarantoolRequestMetadata> requestFutures = new ConcurrentHashMap<Long, TarantoolRequestMetadata>();

    public RequestFutureManager(TarantoolClientConfig config, ScheduledExecutorService timeoutScheduler) {
        this.config = config;
        this.timeoutScheduler = timeoutScheduler;
    }

    public <T> CompletableFuture<T> submitRequest(TarantoolRequest request, MessagePackValueMapper resultMapper) {
        return this.submitRequest(request, this.config.getRequestTimeout(), resultMapper);
    }

    public <T> CompletableFuture<T> submitRequest(TarantoolRequest request, int requestTimeout, MessagePackValueMapper resultMapper) {
        CompletableFuture requestFuture = new CompletableFuture();
        long requestId = request.getHeader().getSync();
        requestFuture.whenComplete((r, e) -> this.requestFutures.remove(requestId));
        this.requestFutures.put(requestId, new TarantoolRequestMetadata(requestFuture, resultMapper));
        this.timeoutScheduler.schedule(() -> {
            if (!requestFuture.isDone()) {
                requestFuture.completeExceptionally(new TimeoutException(String.format("Failed to get response for request %d within %d ms", requestId, requestTimeout)));
            }
        }, (long)requestTimeout, TimeUnit.MILLISECONDS);
        return requestFuture;
    }

    public TarantoolRequestMetadata getRequest(Long requestId) {
        return this.requestFutures.get(requestId);
    }

    @Override
    public void close() {
        this.requestFutures.values().forEach(f -> f.getFuture().join());
    }
}

