/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfigurator;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.proxy.ProxyOperationsMappingConfig;
import io.tarantool.driver.api.retry.RequestRetryPolicyFactory;
import io.tarantool.driver.api.retry.TarantoolRequestRetryPolicies;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.core.ClusterTarantoolTupleClient;
import io.tarantool.driver.core.ProxyTarantoolTupleClient;
import io.tarantool.driver.core.RetryingTarantoolTupleClient;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class TarantoolClientConfiguratorImpl<SELF extends TarantoolClientConfigurator<SELF>>
implements TarantoolClientConfigurator<SELF> {
    private final TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> client;
    protected RequestRetryPolicyFactory retryPolicyFactory;
    protected ProxyOperationsMappingConfig mappingConfig;

    public TarantoolClientConfiguratorImpl(TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> client) {
        this.client = client;
    }

    protected TarantoolClientConfiguratorImpl() {
        this.client = new ClusterTarantoolTupleClient();
    }

    @Override
    public SELF withProxyMethodMapping() {
        return this.withProxyMethodMapping(UnaryOperator.identity());
    }

    @Override
    public SELF withProxyMethodMapping(UnaryOperator<ProxyOperationsMappingConfig.Builder> builder) {
        this.mappingConfig = ((ProxyOperationsMappingConfig.Builder)builder.apply(ProxyOperationsMappingConfig.builder())).build();
        return this.getSelf();
    }

    @Override
    public SELF withRetryingByNumberOfAttempts(int numberOfAttempts) {
        return this.withRetryingByNumberOfAttempts(numberOfAttempts, UnaryOperator.identity());
    }

    @Override
    public SELF withRetryingByNumberOfAttempts(int numberOfAttempts, UnaryOperator<TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder<Function<Throwable, Boolean>>> policy) {
        return this.withRetryingByNumberOfAttempts(numberOfAttempts, TarantoolRequestRetryPolicies.retryNetworkErrors(), policy);
    }

    @Override
    public <T extends Function<Throwable, Boolean>> SELF withRetryingByNumberOfAttempts(int numberOfAttempts, T exceptionsCheck, UnaryOperator<TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder<T>> policy) {
        return this.withRetrying(((TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.Builder)policy.apply(TarantoolRequestRetryPolicies.AttemptsBoundRetryPolicyFactory.builder(numberOfAttempts, exceptionsCheck))).build());
    }

    @Override
    public SELF withRetryingIndefinitely(UnaryOperator<TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder<Function<Throwable, Boolean>>> policy) {
        return this.withRetryingIndefinitely(TarantoolRequestRetryPolicies.retryNetworkErrors(), policy);
    }

    @Override
    public <T extends Function<Throwable, Boolean>> SELF withRetryingIndefinitely(T callback, UnaryOperator<TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder<T>> policy) {
        return this.withRetrying(((TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.Builder)policy.apply(TarantoolRequestRetryPolicies.InfiniteRetryPolicyFactory.builder(callback))).build());
    }

    @Override
    public SELF withRetrying(RequestRetryPolicyFactory factory) {
        this.retryPolicyFactory = factory;
        return this.getSelf();
    }

    @Override
    public TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> build() {
        return this.decorate(this.client);
    }

    protected TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> decorate(TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> client) {
        if (this.mappingConfig != null) {
            client = new ProxyTarantoolTupleClient(client, this.mappingConfig);
        }
        if (this.retryPolicyFactory != null) {
            client = new RetryingTarantoolTupleClient(client, this.retryPolicyFactory);
        }
        return client;
    }

    private SELF getSelf() {
        return (SELF)this;
    }
}

