/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.conditions;

import io.tarantool.driver.api.conditions.IdIndex;
import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.exceptions.TarantoolIndexNotFoundException;
import io.tarantool.driver.utils.Assert;
import java.util.Objects;
import java.util.Optional;

public class IdIndexImpl
implements IdIndex {
    private static final long serialVersionUID = 20200708L;
    private final int position;

    public IdIndexImpl(int position) {
        Assert.state(position >= 0, "Index position should be greater or equal 0");
        this.position = position;
    }

    @Override
    public TarantoolIndexMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolIndexMetadata> indexMetadata = metadataOperations.getIndexById(spaceMetadata.getSpaceName(), this.position);
        if (!indexMetadata.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceMetadata.getSpaceName(), this.position);
        }
        return indexMetadata.get();
    }

    @Override
    public Integer toIdentifier() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdIndexImpl idIndex = (IdIndexImpl)o;
        return this.position == idIndex.position;
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }
}

