/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.utils.Assert;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;

public class TarantoolMetadata
implements TarantoolMetadataOperations {
    protected final Map<String, TarantoolSpaceMetadata> spaceMetadataByName = new ConcurrentHashMap<String, TarantoolSpaceMetadata>();
    protected final Map<Integer, TarantoolSpaceMetadata> spaceMetadataById = new ConcurrentHashMap<Integer, TarantoolSpaceMetadata>();
    protected final Map<String, Map<String, TarantoolIndexMetadata>> indexMetadataBySpaceName = new ConcurrentHashMap<String, Map<String, TarantoolIndexMetadata>>();
    protected final Map<Integer, Map<String, TarantoolIndexMetadata>> indexMetadataBySpaceId = new ConcurrentHashMap<Integer, Map<String, TarantoolIndexMetadata>>();
    private final Phaser initPhaser = new Phaser(0);
    private final AtomicBoolean needRefresh = new AtomicBoolean(true);
    private final TarantoolMetadataProvider metadataProvider;

    public TarantoolMetadata(TarantoolMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected Map<String, TarantoolSpaceMetadata> getSpaceMetadata() {
        this.awaitInitLatch();
        return this.spaceMetadataByName;
    }

    protected Map<Integer, TarantoolSpaceMetadata> getSpaceMetadataById() {
        this.awaitInitLatch();
        return this.spaceMetadataById;
    }

    protected Map<String, Map<String, TarantoolIndexMetadata>> getIndexMetadata() {
        this.awaitInitLatch();
        return this.indexMetadataBySpaceName;
    }

    protected Map<Integer, Map<String, TarantoolIndexMetadata>> getIndexMetadataBySpaceId() {
        this.awaitInitLatch();
        return this.indexMetadataBySpaceId;
    }

    @Override
    public void scheduleRefresh() {
        this.needRefresh.set(true);
    }

    @Override
    public CompletableFuture<Void> refresh() throws TarantoolClientException {
        return this.populateMetadata().whenComplete((v, ex) -> {
            if (ex != null) {
                this.needRefresh.set(true);
            }
            this.initPhaser.arriveAndDeregister();
        });
    }

    private void awaitInitLatch() {
        if (this.initPhaser.getRegisteredParties() == 0 && this.needRefresh.compareAndSet(true, false)) {
            this.initPhaser.register();
            try {
                this.refresh().get();
            }
            catch (InterruptedException e) {
                throw new TarantoolClientException("Failed to refresh spaces and indexes metadata", e);
            }
            catch (ExecutionException e) {
                throw new TarantoolClientException("Failed to refresh spaces and indexes metadata", e.getCause());
            }
        } else {
            this.initPhaser.awaitAdvance(this.initPhaser.getPhase());
        }
    }

    private CompletableFuture<Void> populateMetadata() {
        CompletableFuture<Void> result = new CompletableFuture();
        try {
            result = this.metadataProvider.getMetadata().thenAccept(container -> {
                this.spaceMetadataByName.clear();
                this.spaceMetadataById.clear();
                this.indexMetadataBySpaceName.clear();
                this.indexMetadataBySpaceId.clear();
                this.indexMetadataBySpaceName.putAll(container.getIndexMetadataBySpaceName());
                container.getSpaceMetadataByName().forEach((spaceName, spaceMetadata) -> {
                    this.spaceMetadataByName.put((String)spaceName, (TarantoolSpaceMetadata)spaceMetadata);
                    this.spaceMetadataById.put(spaceMetadata.getSpaceId(), (TarantoolSpaceMetadata)spaceMetadata);
                    Map<String, TarantoolIndexMetadata> indexesForSpace = this.indexMetadataBySpaceName.get(spaceMetadata.getSpaceName());
                    if (indexesForSpace != null) {
                        this.indexMetadataBySpaceId.put(spaceMetadata.getSpaceId(), indexesForSpace);
                    }
                });
            });
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceByName(String spaceName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        return Optional.ofNullable(this.getSpaceMetadata().get(spaceName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(int spaceId, String indexName) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        Assert.hasText(indexName, "Index name must not be null or empty");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadataBySpaceId().get(spaceId);
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(String spaceName, String indexName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        Assert.hasText(indexName, "Index name must not be null or empty");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceName);
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(String spaceName, int indexId) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        Assert.state(indexId >= 0, "Index ID must be greater than or equal 0");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceName);
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(int spaceId, int indexId) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        Assert.state(indexId >= 0, "Index ID must be greater than or equal 0");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadataBySpaceId().get(spaceId);
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceById(int spaceId) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        return Optional.ofNullable(this.getSpaceMetadataById().get(spaceId));
    }

    @Override
    public Optional<Map<String, TarantoolIndexMetadata>> getSpaceIndexes(int spaceId) {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        return Optional.ofNullable(this.getIndexMetadataBySpaceId().get(spaceId));
    }

    @Override
    public Optional<Map<String, TarantoolIndexMetadata>> getSpaceIndexes(String spaceName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        return Optional.ofNullable(this.getIndexMetadata().get(spaceName));
    }
}

