/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TarantoolSpaceMetadataImpl
implements TarantoolSpaceMetadata {
    private static final long serialVersionUID = 20200708L;
    private int spaceId;
    private int ownerId;
    private String spaceName;
    private Map<String, TarantoolFieldMetadata> spaceFormatMetadata;
    private List<TarantoolFieldMetadata> spaceFormatMetadataAsList;

    @Override
    public int getSpaceId() {
        return this.spaceId;
    }

    void setSpaceId(int spaceId) {
        this.spaceId = spaceId;
    }

    @Override
    public int getOwnerId() {
        return this.ownerId;
    }

    void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public String getSpaceName() {
        return this.spaceName;
    }

    void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    @Override
    public Map<String, TarantoolFieldMetadata> getSpaceFormatMetadata() {
        return this.spaceFormatMetadata;
    }

    void setSpaceFormatMetadata(Map<String, TarantoolFieldMetadata> spaceFormatMetadata) {
        this.spaceFormatMetadata = spaceFormatMetadata;
        this.spaceFormatMetadataAsList = new ArrayList<TarantoolFieldMetadata>(spaceFormatMetadata.values());
    }

    @Override
    public Optional<TarantoolFieldMetadata> getFieldByName(String fieldName) {
        TarantoolFieldMetadata fieldMetadata = this.spaceFormatMetadata.get(fieldName);
        return Optional.ofNullable(fieldMetadata);
    }

    @Override
    public Optional<TarantoolFieldMetadata> getFieldByPosition(int fieldPosition) {
        if (fieldPosition >= this.spaceFormatMetadataAsList.size() || fieldPosition < 0) {
            return Optional.empty();
        }
        TarantoolFieldMetadata fieldMetadata = this.spaceFormatMetadataAsList.get(fieldPosition);
        return Optional.of(fieldMetadata);
    }

    @Override
    public int getFieldPositionByName(String fieldName) {
        return this.getFieldByName(fieldName).map(TarantoolFieldMetadata::getFieldPosition).orElse(-1);
    }

    @Override
    public Optional<String> getFieldNameByPosition(int fieldPosition) {
        return this.getFieldByPosition(fieldPosition).map(TarantoolFieldMetadata::getFieldName);
    }

    public String toString() {
        return "TarantoolSpaceMetadata{spaceId=" + this.spaceId + ", ownerId=" + this.ownerId + ", spaceName='" + this.spaceName + '\'' + ", spaceFormatMetadata=" + this.spaceFormatMetadata + ", spaceFormatMetadataAsList=" + this.spaceFormatMetadataAsList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TarantoolSpaceMetadataImpl that = (TarantoolSpaceMetadataImpl)o;
        return this.spaceId == that.spaceId && this.ownerId == that.ownerId && this.spaceName.equals(that.spaceName) && Objects.equals(this.spaceFormatMetadata, that.spaceFormatMetadata) && Objects.equals(this.spaceFormatMetadataAsList, that.spaceFormatMetadataAsList);
    }

    public int hashCode() {
        return Objects.hash(this.spaceId, this.ownerId, this.spaceName, this.spaceFormatMetadata, this.spaceFormatMetadataAsList);
    }
}

