/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.space;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.proxy.ProxyOperationsMappingConfig;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.core.proxy.DeleteProxyOperation;
import io.tarantool.driver.core.proxy.InsertProxyOperation;
import io.tarantool.driver.core.proxy.ProxyOperation;
import io.tarantool.driver.core.proxy.ReplaceProxyOperation;
import io.tarantool.driver.core.proxy.SelectProxyOperation;
import io.tarantool.driver.core.proxy.TruncateProxyOperation;
import io.tarantool.driver.core.proxy.UpdateProxyOperation;
import io.tarantool.driver.core.proxy.UpsertProxyOperation;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public abstract class ProxyTarantoolSpace<T extends Packable, R extends Collection<T>>
implements TarantoolSpaceOperations<T, R> {
    private final String spaceName;
    private final TarantoolClientConfig config;
    private final TarantoolCallOperations client;
    private final TarantoolMetadataOperations metadataOperations;
    private final ProxyOperationsMappingConfig operationsMapping;
    private final TarantoolSpaceMetadata spaceMetadata;

    public ProxyTarantoolSpace(TarantoolClientConfig config, TarantoolCallOperations client, ProxyOperationsMappingConfig operationsMapping, TarantoolMetadataOperations metadata, TarantoolSpaceMetadata spaceMetadata) {
        this.config = config;
        this.client = client;
        this.operationsMapping = operationsMapping;
        this.metadataOperations = metadata;
        this.spaceMetadata = spaceMetadata;
        this.spaceName = spaceMetadata.getSpaceName();
    }

    @Override
    public CompletableFuture<R> delete(Conditions conditions) throws TarantoolClientException {
        return this.delete(conditions, this.tupleResultMapper());
    }

    private CompletableFuture<R> delete(Conditions conditions, CallResultMapper<R, SingleValueCallResult<R>> resultMapper) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
        DeleteProxyOperation operation = new DeleteProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getDeleteFunctionName()).withIndexQuery(indexQuery).withArgumentsMapper(this.config.getMessagePackMapper()).withResultMapper(resultMapper).withRequestTimeout(this.config.getRequestTimeout()).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> insert(T tuple) throws TarantoolClientException {
        return this.insert(tuple, this.tupleResultMapper());
    }

    private CompletableFuture<R> insert(T tuple, CallResultMapper<R, SingleValueCallResult<R>> resultMapper) throws TarantoolClientException {
        InsertProxyOperation operation = new InsertProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getInsertFunctionName()).withTuple(tuple).withArgumentsMapper(this.config.getMessagePackMapper()).withResultMapper(resultMapper).withRequestTimeout(this.config.getRequestTimeout()).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> replace(T tuple) throws TarantoolClientException {
        return this.replace(tuple, this.tupleResultMapper());
    }

    private CompletableFuture<R> replace(T tuple, CallResultMapper<R, SingleValueCallResult<R>> resultMapper) throws TarantoolClientException {
        ReplaceProxyOperation operation = new ReplaceProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getReplaceFunctionName()).withTuple(tuple).withArgumentsMapper(this.config.getMessagePackMapper()).withResultMapper(resultMapper).withRequestTimeout(this.config.getRequestTimeout()).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> select(Conditions conditions) throws TarantoolClientException {
        return this.select(conditions, this.tupleResultMapper());
    }

    private CompletableFuture<R> select(Conditions conditions, CallResultMapper<R, SingleValueCallResult<R>> resultMapper) throws TarantoolClientException {
        SelectProxyOperation operation = new SelectProxyOperation.Builder(this.metadataOperations, this.spaceMetadata).withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getSelectFunctionName()).withConditions(conditions).withArgumentsMapper(this.config.getMessagePackMapper()).withResultMapper(resultMapper).withRequestTimeout(this.config.getRequestTimeout()).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, T tuple) {
        return this.update(conditions, this.makeOperationsFromTuple(tuple), this.tupleResultMapper());
    }

    protected abstract TupleOperations makeOperationsFromTuple(T var1);

    @Override
    public CompletableFuture<R> update(Conditions conditions, TupleOperations operations) {
        return this.update(conditions, operations, this.tupleResultMapper());
    }

    private CompletableFuture<R> update(Conditions conditions, TupleOperations operations, CallResultMapper<R, SingleValueCallResult<R>> resultMapper) {
        TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
        UpdateProxyOperation operation = new UpdateProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getUpdateFunctionName()).withIndexQuery(indexQuery).withTupleOperation(operations).withArgumentsMapper(this.config.getMessagePackMapper()).withResultMapper(resultMapper).withRequestTimeout(this.config.getRequestTimeout()).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations) {
        return this.upsert(conditions, tuple, operations, this.tupleResultMapper());
    }

    private CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations, CallResultMapper<R, SingleValueCallResult<R>> resultMapper) {
        UpsertProxyOperation operation = new UpsertProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getUpsertFunctionName()).withTuple(tuple).withTupleOperation(operations).withArgumentsMapper(this.config.getMessagePackMapper()).withResultMapper(resultMapper).withRequestTimeout(this.config.getRequestTimeout()).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<Void> truncate() throws TarantoolClientException {
        try {
            return this.executeVoidOperation(TruncateProxyOperation.builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.operationsMapping.getTruncateFunctionName()).withRequestTimeout(this.config.getRequestTimeout()).build());
        }
        catch (TarantoolClientException e) {
            throw new TarantoolClientException(e);
        }
    }

    protected abstract CallResultMapper<R, SingleValueCallResult<R>> tupleResultMapper();

    private CompletableFuture<R> executeOperation(ProxyOperation<R> operation) {
        return operation.execute();
    }

    private CompletableFuture<Void> executeVoidOperation(ProxyOperation<Void> operation) {
        return operation.execute();
    }

    @Override
    public TarantoolSpaceMetadata getMetadata() {
        return this.spaceMetadata;
    }

    public String toString() {
        return String.format("ProxyTarantoolSpace [%s]", this.spaceName);
    }
}

