/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.exceptions.errors;

import io.tarantool.driver.exceptions.TarantoolException;
import io.tarantool.driver.exceptions.TarantoolInternalException;
import io.tarantool.driver.exceptions.TarantoolInternalNetworkException;
import io.tarantool.driver.exceptions.errors.TarantoolErrorFactory;
import io.tarantool.driver.protocol.TarantoolErrorResult;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class TarantoolErrors {
    private static final String CLIENT_ERROR = "ClientError";

    public static class TarantoolUnrecognizedErrorFactory
    implements TarantoolErrorFactory {
        @Override
        public Optional<TarantoolException> create(Value error) {
            String exceptionMessage = String.valueOf(error);
            return Optional.of(new TarantoolInternalException(exceptionMessage));
        }
    }

    public static class TarantoolBoxErrorFactory
    implements TarantoolErrorFactory {
        private static final StringValue CODE = ValueFactory.newString((String)"code");
        private static final StringValue BASE_TYPE = ValueFactory.newString((String)"base_type");
        private static final StringValue TYPE = ValueFactory.newString((String)"type");
        private static final StringValue MESSAGE = ValueFactory.newString((String)"message");
        private static final StringValue TRACE = ValueFactory.newString((String)"trace");
        private static final Long ERROR_INDICATOR_OFFSET = 32768L;

        @Override
        public Optional<TarantoolException> create(Value error) {
            if (error == null || !error.isMapValue()) {
                return Optional.empty();
            }
            Map map = error.asMapValue().map();
            String exceptionMessage = "";
            String code = map.containsKey(CODE) ? ((Value)map.get(CODE)).toString() : null;
            String message = map.containsKey(MESSAGE) ? ((Value)map.get(MESSAGE)).toString() : null;
            String type = map.containsKey(TYPE) ? ((Value)map.get(TYPE)).toString() : null;
            String baseType = map.containsKey(BASE_TYPE) ? ((Value)map.get(BASE_TYPE)).toString() : null;
            String trace = map.containsKey(TRACE) ? ((Value)map.get(TRACE)).toString() : null;
            StringBuilder sb = new StringBuilder("InnerErrorMessage:");
            if (code != null) {
                sb.append("\n").append(CODE).append(": ").append(code);
            }
            if (message != null) {
                sb.append("\n").append(MESSAGE).append(": ").append(message);
            }
            if (baseType != null) {
                sb.append("\n").append(BASE_TYPE).append(": ").append(baseType);
            }
            if (type != null) {
                sb.append("\n").append(TYPE).append(": ").append(type);
            }
            if (trace != null) {
                sb.append("\n").append(TRACE).append(": ").append(trace);
            }
            exceptionMessage = sb.toString();
            if (!this.isBoxError(code, message).booleanValue()) {
                return Optional.empty();
            }
            if (this.isNetworkError(code, type).booleanValue()) {
                return Optional.of(new TarantoolInternalNetworkException(exceptionMessage));
            }
            return Optional.of(new TarantoolInternalException(exceptionMessage));
        }

        public TarantoolException create(TarantoolErrorResult error) {
            Long code = error.getErrorCode() - ERROR_INDICATOR_OFFSET;
            String message = error.getErrorMessage();
            StringBuilder sb = new StringBuilder("InnerErrorMessage:");
            sb.append("\n").append(CODE).append(": ").append(code);
            if (message != null) {
                sb.append("\n").append(MESSAGE).append(": ").append(message);
            }
            String exceptionMessage = sb.toString();
            if (this.isNetworkError(code.toString()).booleanValue()) {
                return new TarantoolInternalNetworkException(exceptionMessage);
            }
            return new TarantoolInternalException(exceptionMessage);
        }

        private Boolean isNetworkError(String code, String type) {
            return (code.equals(ErrorsCodes.NO_CONNECTION.getCode()) || code.equals(ErrorsCodes.TIMEOUT.getCode())) && type != null && type.equals(TarantoolErrors.CLIENT_ERROR);
        }

        private Boolean isNetworkError(String code) {
            return code.equals(ErrorsCodes.NO_CONNECTION.getCode()) || code.equals(ErrorsCodes.TIMEOUT.getCode());
        }

        private Boolean isBoxError(String code, String message) {
            return code != null && message != null;
        }
    }

    public static class TarantoolErrorsErrorFactory
    implements TarantoolErrorFactory {
        private static final StringValue LINE = ValueFactory.newString((String)"line");
        private static final StringValue CLASS_NAME = ValueFactory.newString((String)"class_name");
        private static final StringValue ERR = ValueFactory.newString((String)"err");
        private static final StringValue FILE = ValueFactory.newString((String)"file");
        private static final StringValue ERROR_MESSAGE = ValueFactory.newString((String)"str");
        private static final StringValue STACKTRACE = ValueFactory.newString((String)"stack");
        private static final Pattern NETWORK_ERROR_PATTERN = Pattern.compile("(?=.*\"type\":\"ClientError\")(?=.*\"code\":[" + ErrorsCodes.NO_CONNECTION.getCode() + "|" + ErrorsCodes.TIMEOUT.getCode() + "])", 32);

        @Override
        public Optional<TarantoolException> create(Value error) {
            if (error == null || !error.isMapValue()) {
                return Optional.empty();
            }
            Map map = error.asMapValue().map();
            String exceptionMessage = "";
            String errorMessage = map.containsKey(ERROR_MESSAGE) ? ((Value)map.get(ERROR_MESSAGE)).toString() : null;
            String err = map.containsKey(ERR) ? ((Value)map.get(ERR)).toString() : null;
            String line = map.containsKey(LINE) ? ((Value)map.get(LINE)).toString() : null;
            String className = map.containsKey(CLASS_NAME) ? ((Value)map.get(CLASS_NAME)).toString() : null;
            String file = map.containsKey(FILE) ? ((Value)map.get(FILE)).toString() : null;
            String stacktrace = map.containsKey(STACKTRACE) ? ((Value)map.get(STACKTRACE)).toString() : null;
            StringBuilder sb = new StringBuilder("InnerErrorMessage:");
            if (errorMessage != null) {
                sb.append("\n").append(ERROR_MESSAGE).append(": ").append(errorMessage);
            }
            if (line != null) {
                sb.append("\n").append(LINE).append(": ").append(line);
            }
            if (className != null) {
                sb.append("\n").append(CLASS_NAME).append(": ").append(className);
            }
            if (err != null) {
                sb.append("\n").append(ERR).append(": ").append(file);
            }
            if (stacktrace != null) {
                sb.append("\n").append(STACKTRACE).append(": ").append(stacktrace);
            }
            exceptionMessage = sb.toString();
            if (!this.isErrorsError(errorMessage).booleanValue()) {
                return Optional.empty();
            }
            if (this.isNetworkError(err).booleanValue()) {
                return Optional.of(new TarantoolInternalNetworkException(exceptionMessage));
            }
            return Optional.of(new TarantoolInternalException(exceptionMessage));
        }

        private Boolean isNetworkError(String err) {
            if (err == null) {
                return false;
            }
            Matcher matcher = NETWORK_ERROR_PATTERN.matcher(err);
            return matcher.find();
        }

        private Boolean isErrorsError(String errorMessage) {
            return errorMessage != null;
        }
    }

    private static enum ErrorsCodes {
        NO_CONNECTION("77"),
        TIMEOUT("78");

        private final String code;

        private ErrorsCodes(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

