/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.exceptions.errors;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolException;
import io.tarantool.driver.exceptions.errors.TarantoolErrorFactory;
import io.tarantool.driver.exceptions.errors.TarantoolErrors;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.msgpack.core.MessagePackException;
import org.msgpack.value.Value;

public final class TarantoolErrorsParser {
    private static final List<TarantoolErrorFactory> errorsFactories = Arrays.asList(new TarantoolErrors.TarantoolBoxErrorFactory(), new TarantoolErrors.TarantoolErrorsErrorFactory());
    private static final TarantoolErrorFactory defaultFactory = new TarantoolErrors.TarantoolUnrecognizedErrorFactory();

    private TarantoolErrorsParser() {
    }

    public static TarantoolException parse(Value error) {
        try {
            for (TarantoolErrorFactory errorFactory : errorsFactories) {
                Optional<TarantoolException> exception = errorFactory.create(error);
                if (!exception.isPresent()) continue;
                return exception.get();
            }
            return defaultFactory.create(error).get();
        }
        catch (MessagePackException e) {
            throw new TarantoolClientException("Failed to unpack internal error", e);
        }
    }
}

