/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.tarantool.driver.exceptions.errors.TarantoolErrors;
import io.tarantool.driver.protocol.TarantoolErrorResult;
import io.tarantool.driver.protocol.TarantoolResponse;
import java.util.concurrent.CompletableFuture;

public class TarantoolAuthenticationResponseHandler
extends SimpleChannelInboundHandler<TarantoolResponse> {
    private final CompletableFuture<Channel> connectionFuture;
    private final TarantoolErrors.TarantoolBoxErrorFactory boxErrorFactory = new TarantoolErrors.TarantoolBoxErrorFactory();

    public TarantoolAuthenticationResponseHandler(CompletableFuture<Channel> connectionFuture) {
        this.connectionFuture = connectionFuture;
    }

    protected void channelRead0(ChannelHandlerContext ctx, TarantoolResponse tarantoolResponse) throws Exception {
        if (!this.connectionFuture.isDone()) {
            switch (tarantoolResponse.getResponseType()) {
                case IPROTO_NOT_OK: {
                    TarantoolErrorResult errorResult = new TarantoolErrorResult(tarantoolResponse.getSyncId(), tarantoolResponse.getResponseCode(), tarantoolResponse.getBody().getData());
                    this.connectionFuture.completeExceptionally(this.boxErrorFactory.create(errorResult));
                    break;
                }
                case IPROTO_OK: {
                    this.connectionFuture.complete(ctx.channel());
                }
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionFuture.completeExceptionally(cause);
    }
}

