/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.mappers.ObjectConverter;
import io.tarantool.driver.mappers.ValueConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ValueFactory;

public class DefaultBigDecimalConverter
implements ValueConverter<ExtensionValue, BigDecimal>,
ObjectConverter<BigDecimal, ExtensionValue> {
    private static final long serialVersionUID = 20200708L;
    private static final byte DECIMAL_TYPE = 1;
    private static final int DECIMAL_MAX_DIGITS = 38;
    private static final byte DECIMAL_MINUS = 13;
    private static final byte DECIMAL_PLUS = 12;
    private static final byte DECIMAL_MINUS_ALT = 11;

    private byte[] toBytes(BigDecimal object) throws IOException {
        int scale = object.scale();
        if (scale > 38 || scale < -38) {
            throw new IOException(String.format("Scales with absolute value greater than %d are not supported", 38));
        }
        String number = object.unscaledValue().toString();
        int signum = 12;
        int digitsNum = number.length();
        int pos = 0;
        if (number.charAt(0) == '-') {
            signum = 13;
            --digitsNum;
            ++pos;
        }
        int len = (digitsNum >> 1) + 1;
        byte[] bcd = new byte[len];
        bcd[len - 1] = signum;
        char[] digits = number.substring(pos).toCharArray();
        pos = digits.length - 1;
        for (int i = len - 1; i > 0; --i) {
            int n = i;
            bcd[n] = (byte)(bcd[n] | Character.digit(digits[pos--], 10) << 4);
            int n2 = i - 1;
            bcd[n2] = (byte)(bcd[n2] | Character.digit(digits[pos--], 10));
        }
        if (pos == 0) {
            bcd[0] = (byte)(bcd[0] | Character.digit(digits[pos], 10) << 4);
        }
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packInt(scale);
        packer.writePayload(bcd);
        packer.close();
        return packer.toByteArray();
    }

    private BigDecimal fromBytes(byte[] data) throws IOException {
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((ByteBuffer)buffer);
        int scale = unpacker.unpackInt();
        unpacker.close();
        if (scale > 38 || scale < -38) {
            throw new IOException(String.format("Scales with absolute value greater than %d are not supported", 38));
        }
        if (!buffer.hasRemaining()) {
            throw new IOException("Not enough bytes in the packed data");
        }
        int len = data.length;
        int signum = data[len - 1] & 0xF;
        if (signum == 13 || signum == 11) {
            signum = -1;
        } else {
            if (signum <= 9) {
                throw new IOException("The sign nibble has wrong value");
            }
            signum = 1;
        }
        for (i = buffer.position() + 1; i < len && data[i] == 0; ++i) {
        }
        if (len == i && (data[len - 1] & 0xF0) == 0) {
            return BigDecimal.ZERO;
        }
        int digitsNum = len - i << 1;
        char digit = (char)((data[len - 1] & 0xF0) >>> 4);
        if (digit > '\t') {
            throw new IOException(String.format("Invalid digit at position %d", digitsNum - 1));
        }
        char[] digits = new char[digitsNum];
        int pos = 2 * (len - i) - 1;
        digits[pos--] = Character.forDigit(digit, 10);
        for (int j = len - 2; j >= i; --j) {
            digit = (char)(data[j] & 0xF);
            if (digit > '\t') {
                throw new IOException(String.format("Invalid digit at position %d", pos));
            }
            digits[pos--] = Character.forDigit(digit, 10);
            digit = (char)((data[j] & 0xF0) >>> 4);
            if (digit > '\t') {
                throw new IOException(String.format("Invalid digit at position %d", pos - 1));
            }
            digits[pos--] = Character.forDigit(digit, 10);
        }
        StringBuilder sb = new StringBuilder(len - i + 1);
        if (signum < 0) {
            sb.append('-');
        }
        pos = 0;
        while (digits[pos] == '\u0000') {
            ++pos;
        }
        while (pos < digits.length) {
            sb.append(digits[pos]);
            ++pos;
        }
        return new BigDecimal(new BigInteger(sb.toString()), scale);
    }

    @Override
    public ExtensionValue toValue(BigDecimal object) {
        try {
            return ValueFactory.newExtension((byte)1, (byte[])this.toBytes(object));
        }
        catch (IOException e) {
            throw new MessagePackValueMapperException(String.format("Failed to pack BigDecimal %s to MessagePack entity", object), e);
        }
    }

    @Override
    public BigDecimal fromValue(ExtensionValue value) {
        try {
            return this.fromBytes(value.getData());
        }
        catch (IOException e) {
            throw new MessagePackValueMapperException(String.format("Failed to unpack BigDecimal from MessagePack entity %s", value), e);
        }
    }

    @Override
    public boolean canConvertValue(ExtensionValue value) {
        return value.getType() == 1;
    }
}

