/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.mappers.ObjectConverter;
import io.tarantool.driver.mappers.ValueConverter;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ValueFactory;

public class DefaultUUIDConverter
implements ValueConverter<ExtensionValue, UUID>,
ObjectConverter<UUID, ExtensionValue> {
    private static final long serialVersionUID = 20200708L;
    private static final byte UUID_TYPE = 2;

    private byte[] toBytes(UUID value) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        long mostSignificant = value.getMostSignificantBits();
        buffer.putInt((int)(mostSignificant >>> 32)).putShort((short)((mostSignificant & 0xFFFFFFFFL) >>> 16)).putShort((short)(mostSignificant & 0xFFFFL));
        long leastSignificant = value.getLeastSignificantBits();
        buffer.put((byte)(leastSignificant >>> 56)).put((byte)((leastSignificant & 0xFF000000000000L) >>> 48)).put((byte)((leastSignificant & 0xFF0000000000L) >>> 40)).put((byte)((leastSignificant & 0xFF00000000L) >>> 32)).put((byte)((leastSignificant & 0xFF000000L) >>> 24)).put((byte)((leastSignificant & 0xFF0000L) >>> 16)).put((byte)((leastSignificant & 0xFF00L) >>> 8)).put((byte)(leastSignificant & 0xFFL));
        return buffer.array();
    }

    private UUID fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long mostSignificant = ((long)buffer.getInt() & 0xFFFFFFFFL) << 32 | ((long)buffer.getShort() & 0xFFFFL) << 16 | (long)buffer.getShort() & 0xFFFFL;
        long leastSignificant = ((long)buffer.get() & 0xFFL) << 56 | ((long)buffer.get() & 0xFFL) << 48 | ((long)buffer.get() & 0xFFL) << 40 | ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | (long)buffer.get() & 0xFFL;
        return new UUID(mostSignificant, leastSignificant);
    }

    @Override
    public ExtensionValue toValue(UUID object) {
        return ValueFactory.newExtension((byte)2, (byte[])this.toBytes(object));
    }

    @Override
    public UUID fromValue(ExtensionValue value) {
        return this.fromBytes(value.getData());
    }

    @Override
    public boolean canConvertValue(ExtensionValue value) {
        return value.getType() == 2;
    }
}

