/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.cursor;

import io.tarantool.driver.api.cursor.TarantoolCursor;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceOperationException;
import io.tarantool.driver.protocol.Packable;
import java.util.Collection;

public abstract class TarantoolCursorBase<T extends Packable, R extends Collection<T>>
implements TarantoolCursor<T> {
    protected abstract void fetchNextTuples();

    protected abstract boolean advanceIterator();

    protected abstract T getCurrentValue();

    protected static long calcLimit(long conditionLimit, long batchSize, long spaceOffset) {
        long tuplesToFetchLeft;
        if (conditionLimit > 0L && (tuplesToFetchLeft = conditionLimit - spaceOffset) < batchSize) {
            return tuplesToFetchLeft;
        }
        return batchSize;
    }

    @Override
    public boolean next() throws TarantoolClientException {
        if (!this.advanceIterator()) {
            this.fetchNextTuples();
            return this.advanceIterator();
        }
        return true;
    }

    @Override
    public T get() throws TarantoolSpaceOperationException {
        if (this.getCurrentValue() == null) {
            throw new TarantoolSpaceOperationException("Unexpected cursor state: check that next() is called");
        }
        return this.getCurrentValue();
    }
}

