/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.tuple.operations;

import io.tarantool.driver.api.tuple.operations.TarantoolUpdateOperationType;
import io.tarantool.driver.api.tuple.operations.TupleOperation;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import java.util.Arrays;
import java.util.Objects;
import org.msgpack.value.Value;

abstract class TupleUpdateOperation
implements TupleOperation {
    protected final boolean isProxyOperation;
    protected final TarantoolUpdateOperationType operationType;
    protected final Integer fieldIndex;
    protected final String fieldName;
    protected final Object value;

    TupleUpdateOperation(TarantoolUpdateOperationType operationType, int fieldIndex, Object value) {
        this(operationType, fieldIndex, null, value, false);
    }

    TupleUpdateOperation(TarantoolUpdateOperationType operationType, String fieldName, Object value) {
        this(operationType, null, fieldName, value, false);
    }

    TupleUpdateOperation(TarantoolUpdateOperationType operationType, Integer fieldIndex, String fieldName, Object value, boolean isProxyOperation) {
        if (fieldIndex == null && (fieldName == null || fieldName.isEmpty())) {
            throw new IllegalArgumentException("Field name must be not empty");
        }
        this.isProxyOperation = isProxyOperation;
        this.operationType = operationType;
        this.fieldIndex = fieldIndex;
        this.fieldName = fieldName;
        this.value = value;
    }

    @Override
    public Value toMessagePackValue(MessagePackObjectMapper mapper) {
        return mapper.toValue(Arrays.asList(this.getOperationType().toString(), this.getFieldIndex() != null ? this.getFieldIndex() : this.getFieldName(), this.getValue()));
    }

    @Override
    public TarantoolUpdateOperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public Integer getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Boolean isProxyOperation() {
        return this.isProxyOperation;
    }

    protected Integer getFieldNumber() {
        if (this.getFieldIndex() == null) {
            return null;
        }
        return this.isProxyOperation() != false ? this.getFieldIndex() : this.getFieldIndex() + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleUpdateOperation that = (TupleUpdateOperation)o;
        return this.operationType == that.operationType && Objects.equals(this.fieldIndex, that.fieldIndex) && Objects.equals(this.fieldName, that.fieldName) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationType, this.fieldIndex, this.fieldName, this.value});
    }
}

