/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.TarantoolVersion;
import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.connection.TarantoolConnectionListeners;
import io.tarantool.driver.api.metadata.DDLMetadataContainerResult;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.proxy.ProxyOperationsMappingConfig;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.core.metadata.DDLTarantoolSpaceMetadataConverter;
import io.tarantool.driver.core.metadata.ProxyMetadataProvider;
import io.tarantool.driver.core.metadata.TarantoolMetadata;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceNotFoundException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ResultMapperFactoryFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.utils.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.msgpack.value.Value;

public abstract class ProxyTarantoolClient<T extends Packable, R extends Collection<T>>
implements TarantoolClient<T, R> {
    private final TarantoolClientConfig config;
    private final TarantoolClient<T, R> client;
    private final ProxyOperationsMappingConfig mappingConfig;
    private final ProxyMetadataProvider metadataProvider;
    private final AtomicReference<TarantoolMetadata> metadataHolder = new AtomicReference();

    public ProxyTarantoolClient(TarantoolClient<T, R> decoratedClient, ProxyOperationsMappingConfig mappingConfig) {
        Assert.notNull(decoratedClient, "Decorated client must not be null");
        Assert.notNull(mappingConfig, "Proxy operations mapping config must not be null");
        this.client = decoratedClient;
        this.config = decoratedClient.getConfig();
        this.mappingConfig = mappingConfig;
        this.client.getConnectionListeners().clear();
        this.metadataProvider = new ProxyMetadataProvider(this.client, mappingConfig.getGetSchemaFunctionName(), new DDLTarantoolSpaceMetadataConverter(), DDLMetadataContainerResult.class);
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(int spaceId) throws TarantoolClientException {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        TarantoolMetadataOperations metadata = this.metadata();
        Optional<TarantoolSpaceMetadata> meta = metadata.getSpaceById(spaceId);
        if (!meta.isPresent()) {
            throw new TarantoolSpaceNotFoundException(spaceId);
        }
        return this.spaceOperations(this.config, this, this.mappingConfig, metadata, meta.get());
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(String spaceName) {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        TarantoolMetadataOperations metadata = this.metadata();
        Optional<TarantoolSpaceMetadata> meta = metadata.getSpaceByName(spaceName);
        if (!meta.isPresent()) {
            throw new TarantoolSpaceNotFoundException(spaceName);
        }
        return this.spaceOperations(this.config, this, this.mappingConfig, metadata, meta.get());
    }

    protected abstract TarantoolSpaceOperations<T, R> spaceOperations(TarantoolClientConfig var1, TarantoolCallOperations var2, ProxyOperationsMappingConfig var3, TarantoolMetadataOperations var4, TarantoolSpaceMetadata var5);

    @Override
    public TarantoolMetadataOperations metadata() throws TarantoolClientException {
        if (this.metadataHolder.get() == null) {
            this.metadataHolder.compareAndSet(null, new TarantoolMetadata(this.metadataProvider()));
        }
        return this.metadataHolder.get();
    }

    @Override
    public TarantoolMetadataProvider metadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public TarantoolClientConfig getConfig() {
        return this.client.getConfig();
    }

    @Override
    public TarantoolVersion getVersion() throws TarantoolClientException {
        return this.client.getVersion();
    }

    @Override
    public TarantoolConnectionListeners getConnectionListeners() {
        return this.client.getConnectionListeners();
    }

    @Override
    public ResultMapperFactoryFactory getResultMapperFactoryFactory() {
        return this.client.getResultMapperFactoryFactory();
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName) throws TarantoolClientException {
        return this.client.call(functionName);
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, Object ... arguments) throws TarantoolClientException {
        return this.client.call(functionName, Arrays.asList(arguments));
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, List<?> arguments) throws TarantoolClientException {
        return this.client.call(functionName, arguments);
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, List<?> arguments, MessagePackMapper mapper) throws TarantoolClientException {
        return this.client.call(functionName, arguments, mapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, Class<T> entityClass) throws TarantoolClientException {
        return this.client.call(functionName, entityClass);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> resultMapper) throws TarantoolClientException {
        return this.client.call(functionName, resultMapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, Class<T> entityClass) throws TarantoolClientException {
        return this.client.call(functionName, arguments, entityClass);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> resultMapper) throws TarantoolClientException {
        return this.client.call(functionName, arguments, resultMapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<T> entityClass) throws TarantoolClientException {
        return this.client.call(functionName, arguments, argumentsMapper, entityClass);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> call(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> resultMapper) throws TarantoolClientException {
        return this.client.call(functionName, arguments, argumentsMapper, resultMapper);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Class<T> resultClass) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, arguments, argumentsMapper, resultClass);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, arguments, argumentsMapper, valueConverter);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, arguments, argumentsMapper, resultMapper);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, Class<T> resultClass) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, arguments, resultClass);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, arguments, valueConverter);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, List<?> arguments, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, arguments, resultMapper);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, Class<T> resultClass) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, resultClass);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, valueConverter);
    }

    @Override
    public <T> CompletableFuture<T> callForSingleResult(String functionName, CallResultMapper<T, SingleValueCallResult<T>> resultMapper) throws TarantoolClientException {
        return this.client.callForSingleResult(functionName, resultMapper);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, arguments, argumentsMapper, resultContainerSupplier, resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, arguments, argumentsMapper, resultContainerSupplier, valueConverter);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, MessagePackObjectMapper argumentsMapper, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, arguments, argumentsMapper, resultMapper);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, arguments, resultContainerSupplier, resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, arguments, resultContainerSupplier, valueConverter);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, List<?> arguments, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, arguments, resultMapper);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, resultContainerSupplier, resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, resultContainerSupplier, valueConverter);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, CallResultMapper<R, MultiValueCallResult<T, R>> resultMapper) throws TarantoolClientException {
        return this.client.callForMultiResult(functionName, resultMapper);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression) throws TarantoolClientException {
        return this.client.eval(expression);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments) throws TarantoolClientException {
        return this.client.eval(expression, arguments);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.client.eval(expression, resultMapper);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.client.eval(expression, arguments, resultMapper);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, List<?> arguments, MessagePackObjectMapper argumentsMapper, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        return this.client.eval(expression, arguments, argumentsMapper, resultMapper);
    }

    @Override
    public boolean refresh() {
        return this.client.refresh();
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    ProxyOperationsMappingConfig getMappingConfig() {
        return this.mappingConfig;
    }

    TarantoolClient<T, R> getClient() {
        return this.client;
    }
}

