/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.conditions;

import io.tarantool.driver.api.conditions.NamedIndex;
import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.exceptions.TarantoolIndexNotFoundException;
import io.tarantool.driver.utils.Assert;
import java.util.Objects;
import java.util.Optional;

public class NamedIndexImpl
implements NamedIndex {
    private static final long serialVersionUID = 20200708L;
    private final String name;

    public NamedIndexImpl(String name) {
        Assert.hasText(name, "Index name should not be empty");
        this.name = name;
    }

    @Override
    public TarantoolIndexMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolIndexMetadata> indexMetadata = metadataOperations.getIndexByName(spaceMetadata.getSpaceName(), this.name);
        if (!indexMetadata.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceMetadata.getSpaceName(), this.name);
        }
        return indexMetadata.get();
    }

    @Override
    public String toIdentifier() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedIndexImpl that = (NamedIndexImpl)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

