/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolIndexPartMetadata;
import io.tarantool.driver.api.metadata.TarantoolIndexType;
import io.tarantool.driver.core.metadata.TarantoolIndexMetadataImpl;
import io.tarantool.driver.core.metadata.TarantoolIndexOptionsImpl;
import io.tarantool.driver.core.metadata.TarantoolIndexPartMetadataImpl;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ValueConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class TarantoolIndexMetadataConverter
implements ValueConverter<ArrayValue, TarantoolIndexMetadata> {
    private static final long serialVersionUID = 20200708L;
    private static final ImmutableStringValue INDEX_FIELD_KEY = new ImmutableStringValueImpl("field");
    private static final ImmutableStringValue INDEX_TYPE_KEY = new ImmutableStringValueImpl("type");
    private final MessagePackValueMapper mapper;

    public TarantoolIndexMetadataConverter(MessagePackValueMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public TarantoolIndexMetadata fromValue(ArrayValue value) {
        Iterator it = value.iterator();
        TarantoolIndexMetadataImpl metadata = new TarantoolIndexMetadataImpl();
        metadata.setSpaceId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setIndexId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setIndexName((String)this.mapper.fromValue(((Value)it.next()).asStringValue()));
        metadata.setIndexType(TarantoolIndexType.fromString((String)this.mapper.fromValue(((Value)it.next()).asStringValue())));
        TarantoolIndexOptionsImpl indexOptions = new TarantoolIndexOptionsImpl();
        Map optionsMap = (Map)this.mapper.fromValue(((Value)it.next()).asMapValue());
        indexOptions.setUnique((Boolean)optionsMap.get("unique"));
        metadata.setIndexOptions(indexOptions);
        ArrayValue indexPartsValue = ((Value)it.next()).asArrayValue();
        List<TarantoolIndexPartMetadata> indexParts = new ArrayList<TarantoolIndexPartMetadata>();
        if (indexPartsValue.size() > 0) {
            indexParts = indexPartsValue.get(0).isArrayValue() ? indexPartsValue.list().stream().map(partValue -> new TarantoolIndexPartMetadataImpl(partValue.asArrayValue().get(0).asIntegerValue().asInt(), partValue.asArrayValue().get(1).asStringValue().asString())).collect(Collectors.toList()) : indexPartsValue.list().stream().map(partValue -> new TarantoolIndexPartMetadataImpl(((Value)partValue.asMapValue().map().get(INDEX_FIELD_KEY)).asIntegerValue().asInt(), ((Value)partValue.asMapValue().map().get(INDEX_TYPE_KEY)).asStringValue().asString())).collect(Collectors.toList());
        }
        metadata.setIndexParts(indexParts);
        return metadata;
    }
}

