/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.mappers.ObjectConverter;
import io.tarantool.driver.mappers.ValueConverter;
import org.msgpack.value.FloatValue;
import org.msgpack.value.ValueFactory;

public class DefaultFloatConverter
implements ValueConverter<FloatValue, Float>,
ObjectConverter<Float, FloatValue> {
    private static final long serialVersionUID = 20210819L;

    @Override
    public FloatValue toValue(Float object) {
        return ValueFactory.newFloat((float)object.floatValue());
    }

    @Override
    public Float fromValue(FloatValue value) {
        return Float.valueOf(value.toFloat());
    }

    @Override
    public boolean canConvertValue(FloatValue value) {
        double aDouble = value.toDouble();
        return aDouble <= 0.0 ? this.isInAcceptableRange(0.0 - aDouble) : this.isInAcceptableRange(aDouble);
    }

    private boolean isInAcceptableRange(double aDouble) {
        return (double)1.4E-45f <= aDouble && aDouble <= 3.4028234663852886E38 || aDouble == 0.0;
    }
}

