/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.InvalidVersionException;
import java.io.Serializable;
import java.util.Objects;

public class TarantoolVersion
implements Serializable {
    private static final long serialVersionUID = 87703595811996764L;
    private final String fullVersion;

    TarantoolVersion(String versionString) {
        this.fullVersion = versionString;
    }

    public static TarantoolVersion fromString(String versionString) throws InvalidVersionException {
        if (versionString == null || !versionString.startsWith("Tarantool ")) {
            throw new InvalidVersionException(versionString);
        }
        return new TarantoolVersion(versionString.trim());
    }

    public String toString() {
        return this.fullVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TarantoolVersion that = (TarantoolVersion)o;
        return Objects.equals(this.fullVersion, that.fullVersion);
    }

    public int hashCode() {
        return Objects.hash(this.fullVersion);
    }
}

