/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolClusterAddressProvider;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.driver.api.connection.TarantoolConnectionSelectionStrategies;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.core.ClusterTarantoolClient;
import io.tarantool.driver.core.connection.TarantoolConnectionManager;
import io.tarantool.driver.core.space.TarantoolTupleSpace;
import java.util.Collection;
import java.util.Collections;

public class ClusterTarantoolTupleClient
extends ClusterTarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> {
    public ClusterTarantoolTupleClient() {
        this(new SimpleTarantoolCredentials());
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials) {
        this(credentials, Collections.singletonList(new TarantoolServerAddress()));
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials, String host, int port) {
        this(credentials, Collections.singletonList(new TarantoolServerAddress(host, port)));
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, String host, int port) {
        this(config, Collections.singletonList(new TarantoolServerAddress(host, port)));
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials, TarantoolServerAddress address) {
        this(TarantoolClientConfig.builder().withCredentials(credentials).build(), address);
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        this(config, () -> Collections.singletonList(address));
    }

    public ClusterTarantoolTupleClient(TarantoolCredentials credentials, Collection<TarantoolServerAddress> addresses) {
        this(TarantoolClientConfig.builder().withCredentials(credentials).withConnectionSelectionStrategyFactory(TarantoolConnectionSelectionStrategies.ParallelRoundRobinStrategyFactory.INSTANCE).build(), () -> addresses);
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, Collection<TarantoolServerAddress> addresses) {
        this(config, () -> addresses);
    }

    public ClusterTarantoolTupleClient(TarantoolClientConfig config, TarantoolClusterAddressProvider addressProvider) {
        super(config, addressProvider);
    }

    @Override
    protected TarantoolSpaceOperations<TarantoolTuple, TarantoolResult<TarantoolTuple>> spaceOperations(TarantoolClientConfig config, TarantoolConnectionManager connectionManager, TarantoolMetadataOperations metadata, TarantoolSpaceMetadata spaceMetadata) {
        return new TarantoolTupleSpace(this, config, connectionManager, metadata, spaceMetadata);
    }

    @Override
    protected TarantoolClusterAddressProvider getAddressProvider() {
        return super.getAddressProvider();
    }
}

