/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.metadata.TarantoolMetadataContainer;
import io.tarantool.driver.api.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolMetadataRequestException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.Value;

public class ProxyMetadataProvider
implements TarantoolMetadataProvider {
    private final String metadataFunctionName;
    private final TarantoolCallOperations client;
    private final CallResultMapper<TarantoolMetadataContainer, SingleValueCallResult<TarantoolMetadataContainer>> mapper;

    public ProxyMetadataProvider(TarantoolCallOperations client, String metadataFunctionName, ValueConverter<Value, TarantoolMetadataContainer> metadataConverter, Class<? extends SingleValueCallResult<TarantoolMetadataContainer>> resultClass) {
        this.metadataFunctionName = metadataFunctionName;
        this.client = client;
        this.mapper = client.getResultMapperFactoryFactory().singleValueResultMapperFactory().withSingleValueResultConverter(metadataConverter, resultClass);
    }

    @Override
    public CompletableFuture<TarantoolMetadataContainer> getMetadata() {
        return this.client.callForSingleResult(this.metadataFunctionName, this.mapper).exceptionally(ex -> {
            if (ex.getCause() != null && ex.getCause() instanceof TarantoolClientException) {
                throw new TarantoolMetadataRequestException(this.metadataFunctionName, (Throwable)ex);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException((Throwable)ex);
        });
    }
}

