/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolIndexOptions;
import io.tarantool.driver.api.metadata.TarantoolIndexPartMetadata;
import io.tarantool.driver.api.metadata.TarantoolIndexType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

class TarantoolIndexMetadataImpl
implements TarantoolIndexMetadata {
    private int spaceId;
    private int indexId;
    private String indexName;
    private TarantoolIndexType indexType;
    private TarantoolIndexOptions indexOptions;
    private List<TarantoolIndexPartMetadata> indexParts;
    private Map<Integer, TarantoolIndexPartMetadata> indexPartsByPosition;
    private Map<Integer, Integer> fieldPositionToKeyPosition;

    TarantoolIndexMetadataImpl() {
    }

    @Override
    public int getSpaceId() {
        return this.spaceId;
    }

    void setSpaceId(int spaceId) {
        this.spaceId = spaceId;
    }

    @Override
    public int getIndexId() {
        return this.indexId;
    }

    void setIndexId(int indexId) {
        this.indexId = indexId;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public TarantoolIndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public void setIndexType(TarantoolIndexType indexType) {
        this.indexType = indexType;
    }

    @Override
    public TarantoolIndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    @Override
    public void setIndexOptions(TarantoolIndexOptions indexOptions) {
        this.indexOptions = indexOptions;
    }

    @Override
    public void setIndexParts(List<TarantoolIndexPartMetadata> indexParts) {
        this.indexParts = indexParts;
        this.indexPartsByPosition = indexParts.stream().collect(Collectors.toMap(TarantoolIndexPartMetadata::getFieldIndex, Function.identity()));
        this.fieldPositionToKeyPosition = new HashMap<Integer, Integer>();
        int index = 0;
        for (TarantoolIndexPartMetadata meta : indexParts) {
            this.fieldPositionToKeyPosition.put(meta.getFieldIndex(), index++);
        }
    }

    @Override
    public List<TarantoolIndexPartMetadata> getIndexParts() {
        return this.indexParts;
    }

    @Override
    public Map<Integer, TarantoolIndexPartMetadata> getIndexPartsByPosition() {
        return this.indexPartsByPosition;
    }

    @Override
    public Optional<Integer> getIndexPartPositionByFieldPosition(int fieldPosition) {
        return Optional.ofNullable(this.fieldPositionToKeyPosition.get(fieldPosition));
    }

    @Override
    public boolean isPrimary() {
        return this.indexId == 0;
    }

    @Override
    public boolean isUnique() {
        return this.isPrimary() || this.indexOptions.isUnique();
    }
}

