/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.core.metadata.TarantoolFieldMetadataImpl;
import io.tarantool.driver.core.metadata.TarantoolSpaceMetadataImpl;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class TarantoolSpaceMetadataConverter
implements ValueConverter<ArrayValue, TarantoolSpaceMetadata> {
    private static final long serialVersionUID = 20200708L;
    private static final ImmutableStringValue FORMAT_FIELD_NAME = new ImmutableStringValueImpl("name");
    private static final ImmutableStringValue FORMAT_FIELD_TYPE = new ImmutableStringValueImpl("type");
    private static final ImmutableStringValue FORMAT_FIELD_IS_NULLABLE = new ImmutableStringValueImpl("is_nullable");
    private MessagePackValueMapper mapper;

    public TarantoolSpaceMetadataConverter(MessagePackValueMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public TarantoolSpaceMetadata fromValue(ArrayValue value) {
        Iterator it = value.iterator();
        TarantoolSpaceMetadataImpl metadata = new TarantoolSpaceMetadataImpl();
        metadata.setSpaceId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setOwnerId((Integer)this.mapper.fromValue(((Value)it.next()).asIntegerValue()));
        metadata.setSpaceName((String)this.mapper.fromValue(((Value)it.next()).asStringValue()));
        Value spaceMetadataValue = (Value)it.next();
        while (!spaceMetadataValue.isArrayValue()) {
            spaceMetadataValue = (Value)it.next();
        }
        LinkedHashMap<String, TarantoolFieldMetadata> spaceFormatMetadata = new LinkedHashMap<String, TarantoolFieldMetadata>();
        int fieldPosition = 0;
        for (Value fieldValueMetadata : spaceMetadataValue.asArrayValue()) {
            Map fieldMap = fieldValueMetadata.asMapValue().map();
            Optional isNullable = Optional.ofNullable(fieldMap.get(FORMAT_FIELD_IS_NULLABLE));
            spaceFormatMetadata.put(((Value)fieldMap.get(FORMAT_FIELD_NAME)).toString(), new TarantoolFieldMetadataImpl(((Value)fieldMap.get(FORMAT_FIELD_NAME)).asStringValue().asString(), ((Value)fieldMap.get(FORMAT_FIELD_TYPE)).asStringValue().asString(), fieldPosition, isNullable.isPresent() && ((Value)isNullable.get()).asBooleanValue().getBoolean()));
            ++fieldPosition;
        }
        metadata.setSpaceFormatMetadata(spaceFormatMetadata);
        return metadata;
    }
}

