/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.space;

import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.cursor.TarantoolCursor;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.retry.RequestRetryPolicy;
import io.tarantool.driver.api.retry.RequestRetryPolicyFactory;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.protocol.Packable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class RetryingTarantoolSpace<T extends Packable, R extends Collection<T>>
implements TarantoolSpaceOperations<T, R> {
    private final TarantoolSpaceOperations<T, R> spaceOperations;
    private final RequestRetryPolicyFactory retryPolicyFactory;
    private final Executor executor;

    public RetryingTarantoolSpace(TarantoolSpaceOperations<T, R> spaceOperations, RequestRetryPolicyFactory retryPolicyFactory, Executor executor) {
        this.spaceOperations = spaceOperations;
        this.retryPolicyFactory = retryPolicyFactory;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<R> delete(Conditions conditions) throws TarantoolClientException {
        return this.wrapOperation(() -> this.spaceOperations.delete(conditions));
    }

    @Override
    public CompletableFuture<R> insert(T tuple) throws TarantoolClientException {
        return this.wrapOperation(() -> this.spaceOperations.insert((Packable)tuple));
    }

    @Override
    public CompletableFuture<R> replace(T tuple) throws TarantoolClientException {
        return this.wrapOperation(() -> this.spaceOperations.replace((Packable)tuple));
    }

    @Override
    public CompletableFuture<R> select(Conditions conditions) throws TarantoolClientException {
        return this.wrapOperation(() -> this.spaceOperations.select(conditions));
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, T tuple) {
        return this.wrapOperation(() -> this.spaceOperations.update(conditions, (Packable)tuple));
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, TupleOperations operations) {
        return this.wrapOperation(() -> this.spaceOperations.update(conditions, operations));
    }

    @Override
    public CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations) {
        return this.wrapOperation(() -> this.spaceOperations.upsert(conditions, (Packable)tuple, operations));
    }

    @Override
    public CompletableFuture<Void> truncate() throws TarantoolClientException {
        return this.wrapVoidOperation(this.spaceOperations::truncate);
    }

    @Override
    public TarantoolSpaceMetadata getMetadata() {
        return this.spaceOperations.getMetadata();
    }

    @Override
    public TarantoolCursor<T> cursor(Conditions conditions, int batchSize) {
        return this.spaceOperations.cursor(conditions, batchSize);
    }

    @Override
    public TarantoolCursor<T> cursor(Conditions conditions) {
        return this.spaceOperations.cursor(conditions);
    }

    private CompletableFuture<R> wrapOperation(Supplier<CompletableFuture<R>> operation) {
        RequestRetryPolicy retryPolicy = this.retryPolicyFactory.create();
        return retryPolicy.wrapOperation(operation, this.executor);
    }

    private CompletableFuture<Void> wrapVoidOperation(Supplier<CompletableFuture<Void>> operation) {
        RequestRetryPolicy retryPolicy = this.retryPolicyFactory.create();
        return retryPolicy.wrapOperation(operation, this.executor);
    }
}

